% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/naivebayes.R
\name{plot.naiveBayes}
\alias{plot.naiveBayes}
\title{Plots for Naive Bayes Model}
\usage{
\method{plot}{naiveBayes}(x, vars, log.scale = TRUE, show.legend = 1,
  cols = c(color("darkred", alpha = 0.75), color("darkblue", alpha = 0.75)),
  ...)
}
\arguments{
\item{x}{a \code{\link{naiveBayes}} object}

\item{vars}{name or index of naive Bayes components to plot. Will plot all
  if blank.}

\item{log.scale}{(logical)}

\item{show.legend}{either a value or values indicating which plot to show
  the legend, or TRUE/FALSE to show or not show the legend on all plots.}

\item{cols}{Colors for plotting. First element is for linkage, second unlinked}

\item{\ldots}{arguemnts passed into \code{\link{plotBF}}}
}
\value{
plots of Bayes factor from a naive Bayes model
}
\description{
This function attempts to plot all of the component plots in
   one window by using the mfrow argument of par. If more control is desired
   then use \code{\link{plotBF}} to plot individual Bayes factors.
}
\details{
Plots (component) bayes factors from naiveBayes()
}
\examples{
# See vignette: "Statistical Methods for Crime Series Linkage" for usage.
}
\seealso{
\code{\link{plotBF}}, \code{\link{naiveBayes}},
   \code{\link{predict.naiveBayes}}
}

