% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn.R
\name{BN}
\alias{BN}
\title{BN Function}
\usage{
BN(facility, dist = "gamma", ext.dir)
}
\arguments{
\item{facility}{Facility name or building number (.csv file name)}

\item{dist}{Truncated probability distribution (e.g., "gamma", "normal")}

\item{ext.dir}{External directory (full path)}
}
\value{
A Bayesian network that models fissile material operations (op), controls (ctrl),
and parameters that affect nuclear criticality safety
}
\description{
This function creates a Bayesian network from pre-formatted nuclear facility data.
}
\examples{

ext.dir <- paste0(tempdir(), "/criticality/extdata")
dir.create(ext.dir, recursive = TRUE, showWarnings = FALSE)

extdata <- paste0(.libPaths()[1], "/criticality/extdata")
file.copy(paste0(extdata, "/facility.csv"), ext.dir, recursive = TRUE)
file.copy(paste0(extdata, "/mcnp-dataset.RData"), ext.dir, recursive = TRUE)

BN(
  facility = "facility",
  dist = "gamma",
  ext.dir = ext.dir
)

}
