% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lessAOA.R
\name{solve_lessAOA}
\alias{solve_lessAOA}
\title{Determines the solution using the LESS method. Relationships between activities can be given as a list of predecessors or start and end node numbers.}
\usage{
solve_lessAOA(input_data, ICconst, ICslope, predecessors = FALSE)
}
\arguments{
\item{input_data}{Data frame containing the graph structure and activity durations.
For the LESS method and start/end nodes you need 7 columns (the order matters):
\enumerate{
\item \code{from} The number of the node where the activity starts.
\item \code{to} The number of the node where the activity ends.
\item \code{label} Activity labels.
\item \code{time} Normal duration of the activity.
\item \code{bound_time} Boundary (the shortest possible) duration of activities.
\item \code{norm_cost} Normal costs.
\item \code{bound_cost} Boundary costs.
}
For the LESS method and predecessors list you need 6 columns (the order matters):
\enumerate{
\item \code{label} Activity labels.
\item \code{pred} List of predecessors.
\item \code{time} Normal duration of the activity.
\item \code{bound_time} Boundary (the shortest possible) duration of activities.
\item \code{norm_cost} Normal costs.
\item \code{bound_cost} Boundary costs.
}}

\item{ICconst}{Intercept of the indirect cost function.}

\item{ICslope}{Slope of the indirect cost function.}

\item{predecessors}{TRUE if the user data contains a list of immediately preceding activities
If set to \code{FALSE} (default), start nad end nodes are used. If is set to \code{TRUE}, predecessors list is used.}
}
\value{
A list made of a graph and a result set.
}
\description{
Determines the solution using the LESS method. Relationships between activities can be given as a list of predecessors or start and end node numbers.
}
\examples{
z <-  solve_lessAOA(lessexample1, 50, 15)
}
