% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingTargetProb-class}
\alias{.StoppingTargetProb}
\alias{StoppingTargetProb-class}
\title{Stop based on probability of target tox interval}
\description{
Stop based on probability of target tox interval
}
\section{Slots}{

\describe{
\item{\code{target}}{the target toxicity interval, e.g. \code{c(0.2, 0.35)}}

\item{\code{prob}}{required target toxicity probability (e.g. \code{0.4})
for reaching sufficient precision}
}}
\examples{
# As example, here is the rule for: 
#   stopping the study if the posterior probability that [0.2 =< Prob(DLT | dose) <= 0.35] 
#   for the next best dose is above 0.5

myStopping <- StoppingTargetProb(target=c(0.2, 0.35),
                                 prob=0.5)
}
\keyword{classes}

