% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudohaps.R
\name{pseudo_haps}
\alias{pseudo_haps}
\title{Identify haplotypes from clustered SNPs}
\usage{
pseudo_haps(preMGfile, bin_vcf, minHap, LD, het_as = "het", keep_outliers)
}
\arguments{
\item{preMGfile}{SNP clusters from DBscan.}

\item{bin_vcf}{Binary VCF for region of interest reformatted by
run_haplotyping().}

\item{minHap}{Minimum size (nIndividuals) to keep haplotype combinations}

\item{LD}{LD matrix input.}

\item{het_as}{If het_as = "alt", heterozygous SNPs are recoded 'REF/ALT' are
recoded as 'ALT/ALT' to reduce number of unique haplotypes, if het_as =
"het", they are kept as 'REF/ALT'.}

\item{keep_outliers}{When FALSE, marker group smoothing is performed to
remove outliers.}
}
\value{
Returns intermediate of haplotype object
}
\description{
pseudo_haps() calls the most common allelic states for each SNP marker group
across individuals, before building dummy SNPs for each marker group that
mimic the binary vcf format. This is the step which determines the haplotype
combinations, and therefore enables several summaries to be returned - as
contained in the $Hapfile and preliminary $Indfile and finalised $MGfile,
following marker group smoothing. This is an internal function not intended
for external use.
}
