#' Joint probabilities, n=15, symmetric case
#'
#' Joint probabilities of the number C of crossings
#' (0, ... 14) and the longest run L (1, ..., 15) in a
#' series of n=15 independent Bernoulli observations for the
#' symmetric case (success probability 0.5). The probabilities
#' are stored in the "times" representations, multiplied by
#' \eqn{2^{15-1}=16348} and are integers in the symmetric
#' case. Only the joint distributions for n=15, 60, 100
#' and success probabilities 0.5 and 0.6 are included in
#' the package to avoid excessive storage, but many more
#' cases are generated in the script crossrun1.R.
#'
#' @format matrix, 15 rows and 15 columns
#' @source generated by the function crossrunsymm and
#' transformed from an Rmpfr array to a matrix
"joint15symm"

#'
#' Joint probabilities, n=15, success probability 0.6
#'
#' The joint probabilities of the number C og crossings
#' (0, ... 14) and the longest run L (1, ..., 15) in a
#' series of n=15 independent Bernoulli observations for
#' success probability 0.6. The probabilities are stored
#' in the "times" representations, multiplied by
#' \eqn{2^{15-1}=16348}. Only the joint distributions for
#' n=15, 60, 100 and success probabilities 0.5 and 0.6 are
#' included in the package to avoid excessive storage, but
#' many more cases are generated in the script crossrun1.R.
#'
#' @format matrix, 15 rows and 15 columns
#' @source generated by the function crossrunbin and
#' transformed from an Rmpfr array to a matrix
"joint15.6"

#' Joint probabilities, n=60, symmetric case
#'
#' The joint probabilities of the number C og crossings
#' (0, ... 59) and the longest run L (1, ..., 60) in a
#' series of n=60 independent Bernoulli observations for the
#' symmetric case (success probability 0.5). The probabilities
#' are stored in the "times" representations, multiplied by
#' \eqn{2^{60-1}} and are integers in the symmetric
#' case. Only the joint distributions for n=15, 60, 100
#' and success probabilities 0.5 and 0.6 are included in
#' the package to avoid excessive storage, but many more
#' cases are generated in the script crossrun1.R.
#'
#' @format matrix, 60 rows and 60 columns
#' @source generated by the function crossrunsymm and
#' transformed from an Rmpfr array to a matrix
"joint60symm"

#' Joint probabilities, 60, success probability 0.6
#'
#' The joint probabilities of the number C og crossings
#' (0, ... 59) and the longest run L (1, ..., 60) in a
#' series of n=60 independent Bernoulli observations for
#' success probability 0.6. The probabilities are stored
#' in the "times" representations, multiplied by
#' \eqn{2^{60-1}}. Only the joint distributions for
#' n=15, 60, 100 and success probabilities 0.5 and 0.6 are
#' included in the package to avoid excessive storage, but
#' many more cases are generated in the script crossrun1.R.
#'
#' @format matrix, 60 rows and 60 columns
#' @source generated by the function crossrunbin and
#' transformed from an Rmpfr array to a matrix
"joint60.6"

#' Joint probabilities, n=100, symmetric case
#'
#' The joint probabilities of the number C og crossings
#' (0, ... 99) and the longest run L (1, ..., 100) in a
#' series of n=100 independent Bernoulli observations for the
#' symmetric case (success probability 0.5). The probabilities
#' are stored in the "times" representations, multiplied by
#' \eqn{2^{100-1}} and are integers in the symmetric
#' case. Only the joint distributions for n=15, 60, 100
#' and success probabilities 0.5 and 0.6 are included in
#' the package to avoid excessive storage, but many more
#' cases are generated in the script crossrun1.R.
#'
#' @format matrix, 100 rows and 100 columns
#' @source generated by the function crossrunsymm and
#' transformed from an Rmpfr array to a matrix
"joint100symm"

#' Joint probabilities, n=100, success probability 0.6
#'
#' The joint probabilities of the number C og crossings
#' (0, ... 99) and the longest run L (1, ..., 100) in a
#' series of n=100 independent Bernoulli observations for
#' success probability 0.6. The probabilities are stored
#' in the "times" representations, multiplied by
#' \eqn{2^{100-1}}. Only the joint distributions for
#' n=15, 60, 100 and success probabilities 0.5 and 0.6 are
#' included in the package to avoid excessive storage, but
#' many more cases are generated in the script crossrun1.R.
#'
#' @format matrix, 100 rows and 100 columns
#' @source generated by the function crossrunbin and
#' transformed from an Rmpfr array to a matrix
"joint100.6"
