% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.r
\name{boxprobt}
\alias{boxprobt}
\title{Box Cumulative Sums}
\usage{
boxprobt(mtrx)
}
\arguments{
\item{mtrx}{mpfr array}
}
\value{
mpfr array
}
\description{
A box cumulative sum is defined as the
cumulative sum over a lower left rectangle. This function
is primarily for use when the components are point
probabilities for the number of crossings C and the longest
run L, then component (c,l) in the result is the
probability \eqn{P(C \ge c, L \le l)}.
}
\examples{
nill <- Rmpfr::mpfr(0, 120)
one <- Rmpfr::mpfr(1, 120)
two <- Rmpfr::mpfr(2, 120)
contents <- c(one,nill,nill, one,one,one, two,two,two)
mtrx3 <- Rmpfr::mpfr2array(contents, dim = c(3, 3))
print(mtrx3)
print(boxprobt(mtrx3))
}
