% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_helpers.R
\name{group_levels}
\alias{group_levels}
\alias{group_levels.data.frame}
\alias{group_levels.factor}
\alias{group_levels.list}
\title{Group infrequent levels in \code{data}, either a factor or a data.frame}
\usage{
group_levels(data, maximum_levels = 32)

\method{group_levels}{factor}(data, maximum_levels = 32)

\method{group_levels}{data.frame}(data, maximum_levels = 32)

\method{group_levels}{list}(data, maximum_levels = 32)
}
\arguments{
\item{data}{A data.frame or factor. In the first case, \code{group_levels} is applied to each factor in the data.frame.}

\item{maximum_levels}{Numeric. The maximum number of levels allowed per factor}
}
\value{
A factor with at most \code{maximum_levels}, or a data.frame where each factor matches that requirement
}
\description{
Group infrequent levels in \code{data}, either a factor or a data.frame

Group infrequent factor levels in a data.frame

Group infrequent factor levels in a list of data.frames
}
\section{Methods (by class)}{
\itemize{
\item \code{factor}: Group infrequent levels in a factor. Takes a factor, and if that factor has more than 'maximum_levels', it makes a table of level frequencies. The top (maximum_levels-1) are left unchanged, all less frequent levels are grouped into the level "other".

\item \code{data.frame}: Takes a data.frame, and applies group_levels.factor to each column

\item \code{list}: Takes a list of data.frames and applies \code{group_levels.data.frame} to each
}}

