% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crumble_control.R
\name{crumble_control}
\alias{crumble_control}
\title{Crumble control parameters}
\usage{
crumble_control(
  crossfit_folds = 10L,
  mlr3superlearner_folds = 10L,
  zprime_folds = 1L,
  epochs = 100L,
  learning_rate = 0.01,
  batch_size = 64,
  device = c("cpu", "cuda", "mps")
)
}
\arguments{
\item{crossfit_folds}{[\code{numeric(1)}]\cr The number of crossfit folds.}

\item{mlr3superlearner_folds}{[\code{numeric(1)}]\cr The number of `mlr3superlearner` folds.}

\item{zprime_folds}{[\code{numeric(1)}]\cr The number of folds to split that data into for calculating Z'.
With larger sample sizes, a larger number will increase speed.}

\item{epochs}{[\code{numeric(1)}]\cr The number of epochs to train the neural network.}

\item{learning_rate}{[\code{numeric(1)}]\cr The learning rate for the neural network.}

\item{batch_size}{[\code{numeric(1)}]\cr The batch size for mini-batch gradient descent.}

\item{device}{[\code{character(1)}]\cr Object representing the device on which a \code{torch_tensor} is or will be allocated.}
}
\value{
A list of control parameters
}
\description{
Crumble control parameters
}
\examples{
if (torch::torch_is_installed()) crumble_control(crossfit_folds = 5)
}
