% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomize.R
\docType{methods}
\name{dichotomize}
\alias{dichotomize}
\alias{is.dichotomized}
\alias{undichotomize}
\alias{is.dichotomized,Categories-method}
\alias{dichotomize,Categories,numeric-method}
\alias{dichotomize,Categories,logical-method}
\alias{dichotomize,Categories,character-method}
\alias{undichotomize,Categories-method}
\alias{dichotomize,CategoricalVariable,ANY-method}
\alias{dichotomize,CategoricalArrayVariable,ANY-method}
\alias{undichotomize,CategoricalVariable-method}
\alias{undichotomize,CategoricalArrayVariable-method}
\title{Indicate how categories represent a dichotomized value}
\usage{
\S4method{is.dichotomized}{Categories}(x)

\S4method{dichotomize}{Categories,numeric}(x, i)

\S4method{dichotomize}{Categories,logical}(x, i)

\S4method{dichotomize}{Categories,character}(x, i)

\S4method{undichotomize}{Categories}(x)

\S4method{dichotomize}{CategoricalVariable,ANY}(x, i)

\S4method{dichotomize}{CategoricalArrayVariable,ANY}(x, i)

\S4method{undichotomize}{CategoricalVariable}(x)

\S4method{undichotomize}{CategoricalArrayVariable}(x)
}
\arguments{
\item{x}{Categories or a Variable subclass that has Categories}

\item{i}{For the \code{dichotomize} methods, the numeric or logical indices
of the categories to mark as "selected", or if character, the Category
"names". Note that unlike some other categorical variable methods,
numeric indices are positional, not with reference to category ids.}
}
\value{
Categories or the Variable, (un)dichotomized accordingly
}
\description{
Multiple Response variables are essentially Categorical Arrays in which one
or more categories are set as "selected". These methods allow you set that state.
}
\details{
\code{dichotomize} lets you specify which categories are "selected", while
\code{undichotomize} strips that selection information. Dichotomize converts
a Categorical Array to a Multiple Response, and undichotomize does the reverse.
}
\seealso{
\code{\link{describe-category}}
}
