% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-subset.R
\name{translateHidden}
\alias{translateHidden}
\title{Translate provided index to an index which accounts for hidden categories.}
\usage{
translateHidden(index, not_hidden, drop = TRUE, vis = not_hidden)
}
\arguments{
\item{index}{The index to be translated}

\item{not_hidden}{Logical, \code{TRUE} indicates a category is not hidden.}

\item{drop}{Should dimensions with a single category be dropped}

\item{vis}{Logical, is a category visible or not. Because of the \code{useNA} behavior,
categories can be visible even if they are hidden.}
}
\value{
The translated index
}
\description{
When the user subsets a cube in which "useNA" is either "no" or "ifAny" they
are not interacting with hidden categories. This function takes the index which
they provide and translates it to an index which includes hidden categories.
}
\details{
For example, if \code{v} includes c("cat1", "hidden_cat", "cat2") and \code{useNA} is
"no". The user will see \code{v} as c("cat1", "cat2") and might subset it with
\code{v[c(2,1)]}. We need to skip over the hidden category and change the index
to account for any hidden categories which might appear in the vector. Here
the translated index would be \code{c(3,1}. This function does all of that.
}
\keyword{internal}
