% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slides.R
\name{newSlide}
\alias{newSlide}
\title{Append a new slide to a Crunch Deck}
\usage{
newSlide(
  deck,
  query,
  display_settings = list(),
  title = "",
  subtitle = "",
  ...
)
}
\arguments{
\item{deck}{A Crunch Deck}

\item{query}{A formula definition of a query to be used by the slide. This is
similar to CrunchCube query}

\item{display_settings}{(optional) A list of display settings. If omitted,
slide will be a table of column percentages with hypothesis test highlighting
enabled. The most common setting used is \code{vizType}, which can be:
\code{table}, \code{groupedBarPlot}, \code{stackedBarPlot}, \code{horizontalBarPlot},
\code{horizontalStackedBarPlot}, \code{donut}, and (if the second variable in the
query formula is a wave variable) \code{timeplot}.
In addition, \code{showValueLabels} (logical) controls whether the web app and
exports show labels on bars or arcs of donuts.}

\item{title}{The slide's title}

\item{subtitle}{The slide's subtitle}

\item{...}{Further options to be passed on to the API}
}
\value{
CrunchSlide object
}
\description{
Append a new slide to a Crunch Deck
}
\examples{
\dontrun{
newSlide(
    main_deck,
    ~ cyl + wt,
    title = "Cyl and Weight",
    subtitle = "2017 Data"
)

# Grouped bar plot
newSlide(
    main_deck,
    ~ approval + age4,
    title = "Approval by age group",
    display_settings = list(
        vizType = "groupedBarPlot",
        showValueLabels = TRUE
    ),
    subtitle = "2017 Data"
)

# Horizontal stacked bars
newSlide(
    main_deck,
    ~ approval + age4,
    title = "Approval by age group",
    display_settings = list(
        vizType = "horizontalStackedBarPlot"
    ),
    subtitle = "2017 Data"
)

# A donut is only suitable for a single variable
newSlide(
    main_deck,
    ~ approval,
    title = "Approval of new feature",
    display_settings = list(
        vizType = "donut",
        showValueLabels = FALSE
    ),
    subtitle = "2017 Data"
)
}
}
