% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/automation.R
\name{automation-undo}
\alias{automation-undo}
\alias{undoScript}
\alias{revertScript}
\alias{scriptSavepoint}
\alias{undoScript,CrunchDataset,Script-method}
\alias{undoScript,CrunchDataset,ANY-method}
\alias{revertScript,CrunchDataset,Script-method}
\alias{revertScript,CrunchDataset,ANY-method}
\alias{scriptSavepoint,Script-method}
\title{Undo behavior of a Crunch Automation Script}
\usage{
undoScript(dataset, x)

revertScript(dataset, x)

scriptSavepoint(x)

\S4method{undoScript}{CrunchDataset,Script}(dataset, x)

\S4method{undoScript}{CrunchDataset,ANY}(dataset, x)

\S4method{revertScript}{CrunchDataset,Script}(dataset, x)

\S4method{revertScript}{CrunchDataset,ANY}(dataset, x)

\S4method{scriptSavepoint}{Script}(x)
}
\arguments{
\item{dataset}{A \code{CrunchDataset}}

\item{x}{A \code{Script} or index for a \code{ScriptCatalog} (generally a number)}
}
\value{
For \code{undoScript()} and \code{revertSctipt()}, invisibly return the updated dataset.
For \code{scriptSavePoint()} a version list object that can be used in \code{\link[=restoreVersion]{restoreVersion()}}.
}
\description{
There are two ways to revert the output of a script:
\itemize{
\item \code{undoScript()} - A "softer" delete of a script's created artifacts and variables, or
\item \code{revertScript()} - A "harder" revert that returns the dataset to the state it was before
running such script.
}
}
\details{
The difference between both is that a hard revert restores the dataset, as it drops all
ensuing scripts and their output (artifacts and variables), while an undo only deletes the
artifacts and variables created by this script, but changes made by other scripts and this
script's record will remain in place.

The function \code{scriptSavepoint()} gets the version object
}
\seealso{
\code{\link[=runCrunchAutomation]{runCrunchAutomation()}} & \code{\link{script-catalog}}
}
