% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Categories-class}
\alias{Categories-class}
\alias{Categories}
\alias{Category-class}
\alias{Category}
\title{Categories in CategoricalVariables}
\usage{
Categories(..., data = NULL)

Category(..., data = NULL)
}
\arguments{
\item{...}{Category attributes}

\item{data}{For the constructor functions \code{Category} and
\code{Categories}, you can either pass in attributes via \code{...} or you
can create the objects with a fully defined \code{list} representation of
the objects via the \code{data} argument. See the examples.}
}
\description{
CategoricalVariables, as well as the array types composed from
Categoricals, contain Categories. Categories are a subclass of list that
contains only Category objects. Category objects are themselves subclasses of
lists and contain the following fields:
\itemize{
\item "name": The name of the category, must be unique within a set of categories
\item "id": An integer that uniquely identifies the category
\item "numeric_value": A numeric value associated with the category (defaults to NA
meaning that no value is associated, \emph{not} that the category is missing)
\item "missing": Logical indicating whether the category should be considered missing
(defaults to \code{FALSE})
\item "selected": Logical indicating whether the category is selected or not (defaults
to \code{FALSE})
\item "date": A string indicating a day or range of days that should be associated with the
category. Accepted formats are "YYYY-MM-DD" ("2020-01-01") for a day,
"YYYY-WXX" ("2020-W01") for an ISO week (a week that starts on a Monday,
with the first week of the year being the first week with more than 4 days in it),
"YYYY-MM" ("2020-01") for a month, "YYYY" ("2020") for a year, or
"YYYY-MM-DD,YYYY-MM-DD" ("2020-01-01,2020-01-10") for a range of days.
}
}
\examples{
cat.a <- Category(name = "First", id = 1, numeric_value = 1, missing = FALSE)
cat.b <- Category(data = list(name = "First", id = 1, numeric_value = 1, missing = FALSE))
identical(cat.a, cat.b)
cat.c <- Category(name = "Second", id = 2)
cats.1 <- Categories(cat.a, cat.c)
cats.2 <- Categories(data = list(cat.a, cat.c))
identical(cats.1, cats.2)
}
