% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-dataset.R
\name{joinDatasets}
\alias{joinDatasets}
\alias{extendDataset}
\alias{merge.CrunchDataset}
\title{Add columns from one dataset to another, joining on a key}
\usage{
joinDatasets(
  x,
  y,
  by = intersect(names(x), names(y)),
  by.x = by,
  by.y = by,
  all = FALSE,
  all.x = TRUE,
  all.y = FALSE,
  copy = TRUE
)

extendDataset(
  x,
  y,
  by = intersect(names(x), names(y)),
  by.x = by,
  by.y = by,
  all = FALSE,
  all.x = TRUE,
  all.y = FALSE,
  ...
)

\method{merge}{CrunchDataset}(
  x,
  y,
  by = intersect(names(x), names(y)),
  by.x = by,
  by.y = by,
  all = FALSE,
  all.x = TRUE,
  all.y = FALSE,
  ...
)
}
\arguments{
\item{x}{CrunchDataset to add data to}

\item{y}{CrunchDataset to copy data from. May be filtered by rows and/or
columns.}

\item{by}{character, optional shortcut for specifying \code{by.x} and
\code{by.y} by alias if the key variables have the same alias in both
datasets.}

\item{by.x}{CrunchVariable in \code{x} on which to join, or the alias
(following \code{crunch.namekey.dataset} of a variable. Must be type
numeric or text and have all unique, non-missing values.}

\item{by.y}{CrunchVariable in \code{y} on which to join, or the alias
(following \code{crunch.namekey.dataset} of a variable. Must be type
numeric or text and have all unique, non-missing values.}

\item{all}{logical: should all rows in x and y be kept, i.e. a "full outer"
join? Only \code{FALSE} is currently supported.}

\item{all.x}{logical: should all rows in x be kept, i.e. a "left outer"
join? Only \code{TRUE} is currently supported.}

\item{all.y}{logical: should all rows in y be kept, i.e. a "right outer"
join? Only \code{FALSE} is currently supported.}

\item{copy}{logical: make a virtual or materialized join. Default is
\code{TRUE}, which means materialized. Virtual joins are in fact not currently
implemented, so the default is the only valid value.}

\item{...}{additional arguments, ignored}
}
\value{
\code{x} extended by the columns of \code{y}, matched on the "by" variables.
}
\description{
As \code{\link[base:merge]{base::merge()}} does for \code{data.frame}s, this function takes two datasets,
matches rows based on a specified key variable, and adds columns from one to
the other.
}
\details{
Since joining two datasets can sometimes produce unexpected results if the
keys differ between the two datasets, you may want to follow the
fork-edit-merge workflow for this operation. To do this, fork the dataset
with \code{\link[=forkDataset]{forkDataset()}}, join the new data to the fork, ensure that
the resulting dataset is correct, and merge it back to the original dataset
with \code{\link[=mergeFork]{mergeFork()}}. For more, see
\code{vignette("fork-and-merge", package = "crunch")}.
}
