% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/summary-insertions.R
\docType{class}
\name{SummaryStat-class}
\alias{SummaryStat-class}
\alias{SummaryStat}
\alias{is.SummaryStat}
\alias{are.SummaryStats}
\title{Summary insertions}
\usage{
SummaryStat(
  name,
  stat,
  categories = NULL,
  position = c("relative", "top", "bottom"),
  after = NULL,
  before = NULL,
  includeNA = FALSE
)

SummaryStat(
  name,
  stat,
  categories = NULL,
  position = c("relative", "top", "bottom"),
  after = NULL,
  before = NULL,
  includeNA = FALSE
)

is.SummaryStat(x)

are.SummaryStats(x)
}
\arguments{
\item{name}{character the name of the summary statistic}

\item{stat}{a function to calculate the summary (e.g. \code{mean} or \code{median})}

\item{categories}{character or numeric the category names or ids to be
included in the summary statistic, if empty all categories}

\item{position}{character one of "relative", "top", or "bottom". Determines
the position of the subtotal or heading, either at the top, bottom, or
relative to another category in the cube (default)}

\item{after}{character or numeric if \code{position} is "relative", then the
category name or id to position the subtotal or heading after}

\item{before}{character or numeric if \code{position} is relative (and the
insertion type allows it - currently only MR subtotals).}

\item{includeNA}{should missing categories be included in the summary?}

\item{x}{for \code{is.SummaryStat()} only, an object to test if
it is a \code{SummaryStat} object}
}
\description{
Just like \code{subtotals()}s, summary statistics can
be inserted into cubes. \code{SummaryStat()} makes an object of type \code{SummaryStat}
which can be added on to a CrunchCube's \code{insertions} to add the specified
summary statistic. Currently only \code{mean} and \code{median} are supported; both
use weighted algorithms to go from counts and numeric values of
categories to the expected statistic. Although \code{SummaryStat} objects can be
made by hand, it is recommended instead to use the \code{addSummaryStat()}
function which is much quicker and easier to simply add a summary
statistic to an existing CrunchCube.
}
\details{
Summary statistics are intended only for CrunchCube objects, and are not able
to be set on Crunch variables.
}
\section{Removing transforms}{

\code{noTransforms()} is useful if you don't want to see or use any transformations like
Subtotals and Headings. This action only applies to the CrunchCube object in
R: it doesn't actually change the variables on Crunch servers or the query
that generated the CrunchCube.
}

