% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_S3.R
\name{create_rec_unit_cell.bravais}
\alias{create_rec_unit_cell.bravais}
\title{Reciprocal unit cell starting from a Bravais symbol}
\usage{
\method{create_rec_unit_cell}{bravais}(ar, ...)
}
\arguments{
\item{ar}{An object of class "bravais".}

\item{...}{Additional arguments passed to the create_rec_unit_cell methods}
}
\value{
An object of class "rec_unit_cell". It is a named list of length 6 whose
        last three slots are of "angle" class.
}
\description{
Method to create a "rec_unit_cell" object starting from a "bravais" object.
The Bravais symbols indicate the 14 possible Bravais lattices. A few
examples are "aP", "oF", etc. The cell parameters assigned are assigned
randomly, but are compatible with the Bravais lattice.
}
\examples{
# Create a "rec_unit_cell" object from a monoclinic primitive Bravais lattice
# Cell parameters generated automatically.
bt <- bravais("mP")
ruc <- create_rec_unit_cell(bt)
print(ruc)

}
