% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXDS_ASCII.R
\name{readXDS_ASCIIHeader}
\alias{readXDS_ASCIIHeader}
\title{Load an XDS_ASCII file's header.}
\usage{
readXDS_ASCIIHeader(filename)
}
\arguments{
\item{filename}{A character string. The path to a valid
XDS ASCII file.}
}
\value{
A named list. Each name correspond to a valid field in
        the xds header. If \code{filename} is not a valid XDS
        ascii file, the function returns `NULL` and prints out
        a warning message.
}
\description{
This function reads information from the header of an
XDS_ASCII.HKL data file and organises it into a named list
with a variable number of components, according to the type
of XDS_ASCII.HKL file (see details in
\code{\link{readXDS_ASCII}}).
}
\examples{

# Load one of the XDS ASCII files included with
# this distribution of cry
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"xds00_ascii.hkl")
ltmp <- readXDS_ASCIIHeader(filename)
print(names(ltmp))

}
