% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addMA}
\alias{addMA}
\title{Add various Moving Average indicators
to the chart}
\usage{
addMA(chart, FUN = TTR::SMA, ...)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}

\item{FUN}{A named function calculating MAs. Has to be explicitly called. See \code{\link[TTR:MovingAverages]{TTR::SMA()}} for more information.}

\item{...}{See \code{\link[TTR:MovingAverages]{TTR::SMA()}}}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Moving averages are versatile tools used by traders and analysts in various timeframes, from short-term intraday trading to long-term investing.
They help smooth out noise in price data and provide valuable information for decision-making in financial markets.
}
\details{
The function supports all moving averages calculated
by the \link{TTR} library. See \code{\link[TTR:MovingAverages]{TTR::SMA()}} for more information.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addLSRatio}()},
\code{\link{addMACD}()},
\code{\link{addRSI}()},
\code{\link{addVolume}()},
\code{\link{chart}()}
}
\concept{chart indicators}
