% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_exchanges.R
\name{available_exchanges}
\alias{available_exchanges}
\title{Get available exchanges}
\usage{
## available exchanges
## by type
available_exchanges(
   type = "ohlc"
)
}
\arguments{
\item{type}{\link{character}-vector of length 1. See details}
}
\value{
An \code{\link[=invisible]{invisible()}} \link{character} vector containing available exchanges
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get a vector of all available exchanges passed into the source
argument of the get-functions.
}
\details{
\subsection{Available types}{
\itemize{
\item ohlc: Open, High, Low, Close and Volume
\item lsratio: Long-Short ratio
\item fundingrate: Funding rates
\item interest: Open perpetual contracts on both sides
}
}

\subsection{Limits}{

The endpoints supported by the \code{\link[=available_exchanges]{available_exchanges()}} are not uniform,
so exchanges available for, say, \code{\link[=get_lsratio]{get_lsratio()}} is not necessarily the same as those available for \code{\link[=get_quote]{get_quote()}}
}
}
\examples{
# script:
# date: 2023-10-06
# author: Serkan Korkmaz, serkor1@duck.com
# objective:
# script start;

## return all
## available exchanges
cryptoQuotes::available_exchanges()

# script end;
}
\seealso{
Other supported calls: 
\code{\link{available_intervals}()},
\code{\link{available_tickers}()}
}
\author{
Serkan Korkmaz
}
\concept{supported calls}
