% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_fgi.R
\name{fgi}
\alias{fgi}
\title{Chart the Fear and Greed Index}
\usage{
fgi(index, ...)
}
\arguments{
\item{index}{A \code{\link[xts:xts]{xts::xts()}}-object. See \code{\link[=get_fgindex]{get_fgindex()}} for more details.}

\item{...}{For internal use. Please ignore.}
}
\value{
An \link{invisible} \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-wrapper function.
The function adds a subchart with the \verb{fear and greed}-index.
}
\details{
\subsection{Classification}{

The Fear and Greed Index goes from 0-100, and can be classified as follows,

\itemize{
\item 0-24, Extreme Fear
\item 25-44, Fear
\item 45-55, Neutral
\item 56-75, Greed
\item 76-100, Extreme Greed
}
}

\subsection{About the Fear and Greed Index}{

The fear and greed index is a market sentiment indicator that measures
investor emotions to gauge whether they are generally fearful
(indicating potential selling pressure) or
greedy (indicating potential buying enthusiasm).
}

\subsection{Source}{

This index is fetched from
\href{https://alternative.me/crypto/fear-and-greed-index/}{alternative.me},
and can be different from the one provided by
\href{https://coinmarketcap.com/charts/#fear-and-greed-index}{coinmarketcap}.
}
}
\examples{
\dontrun{
  # script start;

  # 1) get the fear and greed index
  # for the last 14 days
  FGIndex <- cryptoQuotes::get_fgindex(
    from = Sys.Date() - 14
  )

  # 2) get the BTC price
  # for the last 14 days
  BTC <- cryptoQuotes::get_quote(
    ticker  = "BTCUSDT",
    source  = "bybit",
    futures = FALSE,
    from    = Sys.Date() - 14
  )

  # 3) chart the daily BTC
  # along side the Fear and
  # Greed Index
  cryptoQuotes::chart(
    ticker = BTC,
    main   = kline(),
    sub    = list(
      fgi(
        FGIndex
      )
    )
  )

  # script end;
}

}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other sentiment indicators: 
\code{\link{lsr}()}

Other subchart indicators: 
\code{\link{add_event}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{smi}()},
\code{\link{volume}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{sentiment indicators}
\concept{subchart indicators}
