% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{csa.plot}
\alias{csa.plot}
\title{CSA curve plotting}
\usage{
csa.plot(x, log_x = TRUE, log_y = TRUE, smooth = FALSE, wn = FALSE)
}
\arguments{
\item{x}{A matrix or data.frame composed of two columns;
scale for the temporal or spatial scale and value for the estimate of a given statistic (e.g., variance) at the given aggregated scale.}

\item{log_x}{logical. If TRUE (the default) the x axis of the CSA plot is set to the logarithmic scale.}

\item{log_y}{logical. If TRUE (the default) the y axis of the CSA plot is set to the logarithmic scale.}

\item{smooth}{logical. If TRUE (the default) the aggregation curves are smoothed (loess function).}

\item{wn}{logical. The argument wn (default FALSE) is used to plot a line presenting the standardized variance of the white noise process.
Therefore, it should be used only with stat = "var" and std = T in the csa/csas functions.}
}
\value{
The CSA plot as a ggplot object.
}
\description{
Function for plotting single CSA curves.
}
\examples{
\donttest{
aa <- rnorm(1000)
csa_aa <- csa(aa, plot = FALSE)
csa.plot(csa_aa)
}
}
