% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drks_de_download.R
\name{drks_de_download}
\alias{drks_de_download}
\title{Mass-download registry entry historical versions from DRKS.de}
\usage{
drks_de_download(drksids, output_filename = NA, quiet = FALSE)
}
\arguments{
\item{drksids}{A list of well-formed DRKS numbers,
e.g. c("DRKS00005219", "DRKS00003170").}

\item{output_filename}{A character string for a filename into which
the dataframe will be written as a CSV,
e.g. "historical_versions.csv". If no output filename is
provided, the data frame of downloaded historical versions will
be returned by the function as a data frame.}

\item{quiet}{A boolean TRUE or FALSE. If TRUE, no messages will be
printed during download. FALSE by default, messages printed for
every version downloaded showing progress.}
}
\value{
If an output filename is specified, on successful
completion, this function returns TRUE and otherwise returns
FALSE. If an output filename is not specified, on successful
completion, this function returns a data frame containing the
historical versions of the clinical trial that have been
retrieved, and in case of error returns FALSE. After
unsuccessful completion, if the function is called again with
the same NCT numbers and output filename, it will check the
output file for errors in the download, remove them and try to
download the historical versions again.
}
\description{
This function will download all DRKS.de registry records for the
TRNs specified. Rather than transcribing TRNs by hand, it is
recommended that you conduct a search for trials of interest using
the DRKS.de web front-end and download the result as a
comma-separated value (CSV) file. The download option labeled "CSV"
on DRKS.de currently produces a zipped semicolon-delimited file,
which must be unzipped before reading. The file can be read in to
memory as a data frame and the \code{drksId} column can be passed
directly to the function as the \code{drksids} argument.
}
\examples{

\dontrun{
filename <- tempfile()
drks_de_download(c("DRKS00005219", "DRKS00003170"), filename)
}

\dontrun{
hv <- drks_de_download("DRKS00005219")
}
}
