% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ctrLoadQueryIntoDbEuctr}
\alias{ctrLoadQueryIntoDbEuctr}
\title{ctrLoadQueryIntoDbEuctr}
\usage{
ctrLoadQueryIntoDbEuctr(queryterm, register, euctrresults, annotation.text,
  annotation.mode, details, parallelretrievals, debug, collection, uri,
  password, verbose, queryupdateterm)
}
\arguments{
\item{queryterm}{Either a string with the full URL of a search in a register
or the data frame returned by the \link{ctrGetQueryUrlFromBrowser} or the
\link{dbQueryHistory} functions.
The queryterm is recorded in the collection \code{ns} for later use to
update records.}

\item{register}{Vector of abbreviations of registers to query, defaults to
"EUCTR"}

\item{euctrresults}{If \code{TRUE}, also download available results when
retrieving and loading trials from EUCTR. This slows down this function.
(For CTGOV, all available results are retrieved and loaded from
ctrdata version 0.9.10 onwards.)}

\item{annotation.text}{Text to be including in the records retrieved
with the current query, in the field "annotation".}

\item{annotation.mode}{One of "append" (default), "prepend" or "replace"
for new annotation.text with respect to any existing annotation for
the records retreived with the current query.}

\item{details}{If \code{TRUE} (default), retrieve full protocol-related
information from EUCTR or XML data from CTGOV, depending on the register
selected. This gives all of the available details for the trials.
Alternatively, set to \code{FALSE} to retrieve only summary information
from EUCTR or CSV data from CTGOV. The full EUCTR information includes
separate records for every country in which the trial is opened; use
function \code{dbFindUniqueEuctrRecord} in a subsequent step to limit to
one record from EUCTR per trial}

\item{parallelretrievals}{Number of parallel downloads of information from
the register}

\item{debug}{Printing additional information if set to \code{TRUE}; default
is \code{FALSE}.}

\item{collection}{Name of collection (default is "ctrdata")}

\item{uri}{Default is mongodb://localhost/users/.
Address of database in mongodb server, based on mongo connection string
format: mongodb://[username@]host1[:port1][,...hostN[:portN]]]/database/
Do NOT include password, this will only be used from the parameter.
See \url{http://docs.mongodb.org/manual/reference/connection-string/}}

\item{password}{In case access requires credentials.
Note this defaults to the environment variable "ctrdatamongopassword".
(by means of \code{Sys.getenv("ctrdatamongopassword")}), to
support scripting without revealing secrets.}

\item{verbose}{Print information.}
}
\description{
ctrLoadQueryIntoDbEuctr
}
\keyword{internal}
