% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dfName2Value}
\alias{dfName2Value}
\title{Extract information of interest (e.g., endpoint)
from long data frame of protocol- or result-related
trial information as returned by \link{dfTrials2Long}}
\usage{
dfName2Value(df, valuename = "", wherename = "", wherevalue = "")
}
\arguments{
\item{df}{A data frame with four columns (_id,
identifier, name, value) as returned by
\link{dfTrials2Long}}

\item{valuename}{A character string for the name of the variable
from which to extract information for the variable of interest}

\item{wherename}{A character string to identify the variable
of interest}

\item{wherevalue}{A character string with the value of interest
for the variable of interest}
}
\value{
A data frame with columns _id, identifier,
 name, value that only includes the values of interest,
 where value are strings unless all value elements
 are numbers.
}
\description{
Extract information of interest (e.g., endpoint)
from long data frame of protocol- or result-related
trial information as returned by \link{dfTrials2Long}
}
\examples{
\dontrun{
db <- nodbi::src_sqlite(
  collection = "my_collection"
)
df <- ctrdata::dbGetFieldsIntoDf(
fields = c(
  # ctgov - typical results fields
  "clinical_results.baseline.analyzed_list.analyzed.count_list.count",
  "clinical_results.baseline.group_list.group",
  "clinical_results.baseline.analyzed_list.analyzed.units",
  "clinical_results.outcome_list.outcome",
  "study_design_info.allocation",
  # euctr - typical results fields
  "trialInformation.fullTitle",
  "subjectDisposition.recruitmentDetails",
  "baselineCharacteristics.baselineReportingGroups.baselineReportingGroup",
  "endPoints.endPoint",
  "trialChanges.hasGlobalInterruptions",
  "subjectAnalysisSets",
  "adverseEvents.seriousAdverseEvents.seriousAdverseEvent"
  ), con = dbc
)
# convert to long
reslong <- ctrdata::dfTrials2Long(
  df = df
)
# get values for endpoint of interest, duration of response
ctrdata::dfValue2Name(
  df = df,
  valuename = paste0(
    "endPoints.endPoint.*armReportingGroup.tendencyValues.tendencyValue.value|",
    "clinical_results.*category.measurement_list.measurement.value|",
    "clinical_results.*outcome.measure.units|endPoints.endPoint.unit"
  ),
  wherename = "clinical_results.*outcome.measure.title|endPoints.endPoint.title",
  wherevalue = "duration of response"
)
}

}
