% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctPlotArray.R
\name{ctPlotArray}
\alias{ctPlotArray}
\title{Plots a three dimensional array}
\usage{
ctPlotArray(yarray, x, grid = TRUE, colvec = "auto", lwdvec = "auto",
  ltyvec = "auto", typevec = "auto", plotcontrol = list(ylab =
  "Array values", xlab = "X values", xaxs = "i"), legend = TRUE,
  legendcontrol = list(x = "topright"), polygon = TRUE,
  polygonalpha = 0.1, polygoncontrol = list(border = NA, steps = 50))
}
\arguments{
\item{yarray}{3 dimensional array to use for Y values}

\item{x}{numeric vector specifying x axis}

\item{grid}{Logical. Plot with a grid?}

\item{colvec}{color vector of same length as 2nd margin.}

\item{lwdvec}{lwd vector of same length as 2nd margin.}

\item{ltyvec}{lty vector of same length as 2nd margin.}

\item{typevec}{type vector of same length as 2nd margin.}

\item{plotcontrol}{list of arguments to pass to plot.}

\item{legend}{Logical. Draw a legend?}

\item{legendcontrol}{list of arguments to pass to \code{\link[graphics]{legend}}.}

\item{polygon}{Logical. Draw the uncertainty polygon?}

\item{polygonalpha}{Numeric, multiplier for alpha (transparency) of the 
uncertainty polygon.}

\item{polygoncontrol}{list of arguments to pass to \code{\link{ctPoly}}}
}
\value{
Nothing. Generates plots.
}
\description{
1st margin sets line values, 2nd sets variables, 3rd quantiles.
}
\examples{
y <- ctStanTIpredeffects(ctstantestfit,plot=FALSE)
x<-ctstantestfit$data$tipreds[order(ctstantestfit$data$tipreds[,1]),1]
ctPlotArray(y,x)
}
