% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ccc.R
\encoding{UTF-8}
\name{plot_ccc}
\alias{plot_ccc}
\title{Constructs a control chart for the cycle lengths of a categorical series}
\usage{
plot_ccc(
  series,
  categories,
  mu_t,
  lcl_t,
  ucl_t,
  plot = TRUE,
  title = "Control chart (cycles)",
  ...
)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{mu_t}{The mean of the process measuring the cycle lengths.}

\item{lcl_t}{The lower control limit.}

\item{ucl_t}{The upper control limit.}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the control
chart. Otherwise, returns the standardized statistic.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
If \code{plot = TRUE} (default), represents the control chart for the cycle lengths. Otherwise, the function
returns a matrix with the values of the standardized statistic for each time t
}
\description{
\code{plot_ccc} constructs a control chart for the cycle lengths of a categorical series
}
\details{
Constructs a control chart of a CTS based on cycle lengths. The chart is based on the
standardized statistic \eqn{T_t=T_t^{(L)}+T_t^{(U)}}, with \eqn{T_t^{(L)}=\min \left(0, \frac{C_t-\mu_t}{\left|L C L_t-\mu_t\right|}\right)}
and \eqn{T_t^{(U)}=\max \left(0, \frac{C_t-\mu_t}{\left|U C L_t-\mu_t\right|}\right)},
where \eqn{Z_t} expresses the length of a cycle ending with a specific category,
\eqn{\mu_t} denotes the mean of \eqn{Z_t} and \eqn{LCL_t} and \eqn{UCL_t} are
lower and upper individual control limits, respectively. Note that an
out-of-control alarm is signalled if \eqn{T_t<-1} or \eqn{T_t>1}.
}
\examples{
cycle_cc <- plot_ccc(series = SyntheticData1$data[[1]],
categories = factor(c('1', '2', '3')), mu_t = c(1, 1.5, 1),
lcl_t = rep(10, 600), ucl_t = rep(10, 600)) # Representing
# a control chart for the cycle lengths
cycle_cc <- plot_ccc(series = SyntheticData1$data[[1]],
categories = factor(c('1', '2', '3')), mu_t = c(1, 1.5, 1),
lcl_t = rep(10, 600), ucl_t = rep(10, 600), plot = FALSE) # Computing the
# corresponding standardized statistic
}
\references{
{

  \insertRef{weiss2008visual}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
