% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubble-accessors.R
\name{[.spatial_cubble_df}
\alias{[.spatial_cubble_df}
\alias{[.temporal_cubble_df}
\alias{names<-.spatial_cubble_df}
\alias{names<-.temporal_cubble_df}
\alias{[[<-.cubble_df}
\title{Accessors to a cubble object}
\usage{
\method{[}{spatial_cubble_df}(data, i, j, drop = FALSE)

\method{[}{temporal_cubble_df}(data, i, j, drop = FALSE)

\method{names}{spatial_cubble_df}(x) <- value

\method{names}{temporal_cubble_df}(x) <- value

\method{[[}{cubble_df}(x, i) <- value
}
\arguments{
\item{data}{an object of class \code{spatial_cubble_df} or
\code{temporal_cubble_df}}

\item{i, j}{row and column selector}

\item{drop}{logical.  If \code{TRUE} the result is coerced to the
    lowest possible dimension.  The default is to drop if only one
    column is left, but \bold{not} to drop if only one row is left.}

\item{x}{data frame.}

\item{value}{A suitable replacement value: it will be repeated a whole
    number of times if necessary and it may be coerced: see the
    Coercion section.  If \code{NULL}, deletes the column if a single
    column is selected.}
}
\description{
Accessors to a cubble object
}
\details{
For nested cubbles, \code{[} will return a cubble object if the \code{key}
variable, the\code{coords} variables, and the \code{ts} column all present.
If the cubble object is also an sf object, the sticky select behavior on
the sf column will preserve. For long cubbles, \code{[} will return a cubble
object if the \code{key} and \code{index} variable both present.
When a cubble can't be created and the data is not an sf class,
\code{[} will always return a tibble, even with single index selection.
}
\examples{
climate_mel[c(1:3, 7)] # a nested cubble
make_spatial_sf(climate_mel)[1:3] # an sf

long <- climate_mel \%>\% face_temporal()
long[1:3] # a long cubble

climate_mel[1:3] # tibble
long[2:5] # tibble
climate_mel[1] # still tibble
long[1] # and still tibble
}
