% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{load_database}
\alias{load_database}
\title{Load database}
\usage{
load_database(x, target)
}
\arguments{
\item{x}{Path to a (minimum) two column TSV file or tidy dataframe (e.g.
tibble), one column with taxon names and other indicating if from
target isolation source.}

\item{target}{the string in the 'Isolation Source' (i.e. 2nd) column which
is the expected target source of the samples}
}
\value{
A tibble, formatted for use in downstream cuperdec functions.
}
\description{
Loads a taxon/isolation source database file, i.e. first column is
a list of taxa, and the second column is a list of isolation sources, and
formats for downstream analysis.
}
\details{
Taxon names should match that with the taxa table.
}
\examples{
data(cuperdec_database_ex)
iso_database <- load_database(cuperdec_database_ex, target = "oral")
}
