% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/2arm_1-reproduce-results-functions-find-designs.R
\name{twoarmDesign}
\alias{twoarmDesign}
\title{Find two-arm trial designs that use stochastic curtailment}
\usage{
twoarmDesign(
  nmin.arm,
  nmax.arm,
  block.size,
  pc,
  pt,
  alpha,
  power,
  maxthetaF = NULL,
  minthetaE = 0.7,
  bounds = "ahern",
  fixed.r = NULL,
  max.combns = 1e+06,
  rm.dominated.designs = TRUE,
  exact.thetaF = NULL,
  exact.thetaE = NULL,
  fast.method = FALSE
)
}
\arguments{
\item{nmin.arm}{Minimum permitted sample size \emph{per arm}. Should be a multiple of block size.}

\item{nmax.arm}{Maximum permitted sample size \emph{per arm}. Should be a multiple of block size.}

\item{block.size}{Block size.}

\item{pc}{Anticipated response rate on the control arm.}

\item{pt}{Anticipated response rate on the treatment arm.}

\item{alpha}{Significance level}

\item{power}{Required power (1-beta).}

\item{maxthetaF}{Maximum value of lower CP threshold theta_F_max.}

\item{minthetaE}{Minimum value of upper threshold theta_E_min.}

\item{bounds}{choose what final rejection boundaries should be searched over: Those of A'Hern ("ahern"), Wald ("wald") or no constraints (NA). Defaults to "wald".}

\item{fixed.r}{Choose what final rejection boundaries should be searched over. Useful for reproducing a particular design realisation. Defaults to NULL.}

\item{max.combns}{Provide a maximum number of ordered pairs (theta_F, theta_E). Defaults to 1e6.}

\item{rm.dominated.designs}{Logical. If TRUE, dominated designs will be
removed from final output. Defaults to TRUE.}

\item{exact.thetaF}{Provide an exact value for lower threshold theta_F. Useful for reproducing a particular design realisation. Defaults to NULL.}

\item{exact.thetaE}{Provide an exact value for upper threshold theta_E. Useful for reproducing a particular design realisation. Defaults to NULL.}

\item{fast.method}{Logical. If FALSE, design search is conducted over all combinations of
(theta_F, theta_E). If TRUE, a much faster, though less thorough, design search is undertaken.
Defaults to FALSE.}
}
\value{
Output is a list of two dataframes. The first, $input, is a one-row data frame that contains all the arguments used in the call.
The second, $all.des, contains the operating characteristics of all admissible designs found.
}
\description{
This function finds admissible design realisations for two-arm binary outcome trials, using stochastic curtailment.
The output can be used as the sole argument in the function 'drawDiagram', which will return the stopping boundaries for the
admissible design of your choice. Monitoring frequency can set in terms of block size.
}
\examples{
\donttest{
des <- twoarmDesign(nmin.arm=20,
nmax.arm=24,
block.size=8,
pc=0.1,
pt=0.4,
alpha=0.1,
power=0.8,
maxthetaF=0.4,
minthetaE=0.7,
max.combns=1e4)
}
}
\author{
Martin Law, \email{martin.law@mrc-bsu.cam.ac.uk}
}
