% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_endpoints}
\alias{set_endpoints}
\title{Set effect endpoints}
\usage{
set_endpoints(x, endpoints)
}
\arguments{
\item{x}{vector of \code{EffectScenario} objects}

\item{endpoints}{\code{character} vector of endpoint names}
}
\value{
Modified \code{EffectScenario} objects
}
\description{
Effect endpoints calculated by functions such as \code{\link[=effect]{effect()}} and \code{\link[=epx]{epx()}}
can be enabled and disabled. If an endpoint is not required for an assessment,
it should be disabled for reasons of computational efficiency. Please refer
to the model description for a list of available endpoints.
}
\examples{
# Only enable reproduction (R) endpoint for americamysis scenario
americamysis \%>\%
  set_endpoints("R") \%>\%
  effect()

# Enable endpoints length (L) and reproduction (R)
americamysis \%>\%
  set_endpoints(c("L","R")) \%>\%
  effect()
}
