% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epx.R
\name{epx}
\alias{epx}
\title{Effect profiles (EPx values)}
\usage{
epx(
  scenarios,
  level = c(10, 50),
  effect_tolerance = 0.001,
  factor_cutoff = NA,
  min_factor = 1e-30,
  max_factor = 1e+30,
  verbose = FALSE,
  ep_only = FALSE,
  long_format = FALSE,
  ...
)
}
\arguments{
\item{scenarios}{table or vector of \code{EffectScenario} objects}

\item{level}{effect levels in percent (\%), defaults to \code{c(10,50)}}

\item{effect_tolerance}{\code{numeric}, minimum absolute accuracy of effect levels}

\item{factor_cutoff}{optional \code{numeric}, the search for a multiplication factor
will be cut short if  tried factors exceed this value; the result will report
the cutoff value as the final EPx value.}

\item{min_factor}{\code{numeric}, if tried factors fall below this threshold, the algorithm
will halt with an error}

\item{max_factor}{\code{numeric}, if tried factors exceed this threshold, the algorithm
will halt with an error}

\item{verbose}{\code{logic}, if \code{TRUE} then infos about model evaluations are displayed}

\item{ep_only}{\code{logical}, if \code{TRUE} then only EPx values are part of the output,
any contextual information such as \code{EffectScenario} objects are left out}

\item{long_format}{\code{logical}, if \code{TRUE} then EPx values are returned as
a table in long format, any contextual information will be duplicated}

\item{...}{additional arguments passed on to \code{\link[=effect]{effect()}}}
}
\value{
The original \code{tibble} with additional columns named after the request effect levels, e.g. \code{L.EP10.}
If no tibble was used as argument, then a new one is created. The first column \code{scenario} will contain
the supplied \code{EffectScenario} objects.
}
\description{
Derives one or more EPx/LPx values for the supplied effect scenarios, i.e. it
calculates the multiplication factors of an exposure profile that cause
x\% of effect. Scenarios are processed in parallel, if possible.
}
\details{
To estimate EPx values, a \emph{binary search} on multiplication factors is conducted.
The algorithm can achieve arbitrary precision in terms of effects. The
same approach is implemented in the \code{morse} package in the \code{MFx()} function.
Convergence is often achieved in less than 10 iterations per effect level and
endpoint.

Internally, a knowledge base of all tried factors and resulting effect levels is
kept to speed up convergence if more than one endpoint or effect level was
requested. The algorithm will automatically sweep the range of multiplication
factors as needed but hard cutoff values are implemented to avoid infinite loops;
the algorithm will halt with an error message if tried factors are
smaller than \code{1e-30} or greater than \code{1e30}.
\subsection{Numerical precision}{

The precision of reported \emph{EPx} values is controlled by the argument
\code{effect_tolerance} and is given as the upper absolute error threshold of
effects that is deemed acceptable. The default value of \code{0.001} ensures that
a derived \emph{EPx} will result in an effect of x\% ± 0.1. Decreasing the
\code{effect_tolerance} will result in additional model iterations and longer
runtime. Setting an extremely small tolerance value may lead to a breakdown
of the algorithm due to the occurrence of extremely small, quasi-random
numerical errors in simulation results.
}
}
\examples{
minnow_sd \%>\% epx()
minnow_sd \%>\% epx(level=c(10,23,42))

# displays infos about tested multiplication factors
minnow_sd \%>\% epx(verbose=TRUE)

# return results as a table in wide format
minnow_sd \%>\% epx(long_format=TRUE)
}
