% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{focusd1}
\alias{focusd1}
\title{A Lemna_SETAC scenario with variable environment}
\format{
An object of class \code{LemnaSetac} of length 1.
}
\usage{
focusd1
}
\description{
A mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and growth
model for the aquatic macrophytes Lemna spp. as published by
Klein \emph{et al.} (2021).
}
\details{
The scenario will simulate a period of 365 days, a start
population of 80 g/m² dry weight, variable environmental conditions, and a
complex, time-varying exposure pattern.

The scenario setup was published by Hommen \emph{et al}. (2015). Exposure pattern
and substance specific parameters are of exemplary character
and represent the herbicide \emph{metsulfuron-methyl}. The parameters were
derived by Schmitt et al. (2013) based on literature
data.
}
\examples{
# Simulate the example scenario
focusd1 \%>\% simulate()

}
\references{
Hommen U., Schmitt W., Heine S., Brock Theo CM., Duquesne S., Manson P., Meregalli G.,
Ochoa-Acuña H., van Vliet P., Arts G., 2015: How TK-TD and Population Models for
Aquatic Macrophytes Could Support the Risk Assessment for Plant Protection
Products. Integr Environ Assess Manag 12(1), pp. 82-95.
\doi{10.1002/ieam.1715}

Klein J., Cedergreen N., Heine S., Reichenberger S., Rendal C.,
Schmitt W., Hommen U., 2021: Refined description of the \emph{Lemna} TKTD growth model
based on \emph{Schmitt et al.} (2013) - equation system and default parameters.
Report of the working group \emph{Lemna} of the SETAC Europe Interest Group Effect
Modeling. Version 1, uploaded on 22. Sept. 2021.
\url{https://www.setac.org/group/effect-modeling.html}

Schmitt W., Bruns E., Dollinger M., Sowig P., 2013: Mechanistic TK/TD-model
simulating the effect of growth inhibitors on \emph{Lemna} populations. Ecol Model
255, pp. 1-10. \doi{10.1016/j.ecolmodel.2013.01.017}
}
\seealso{
\link{Lemna-models}
}
\keyword{datasets}
