% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debris_nc.R
\name{debris_nc}
\alias{debris_nc}
\title{gates out or assign indicators to debris particle.}
\usage{
debris_nc(flowframe, p1, p2)
}
\arguments{
\item{flowframe}{flowframe with debris, BS4, BS5 and other cells.}

\item{p1}{first flowcytometer channel that can be used to separate debris
from the rest, e.g. "RED.B.HLin".}

\item{p2}{second flowcytometer channel that can be used to separate debris
from the rest, e.g. "YEL.B.HLin"}
}
\value{
list containing; \itemize{
\item \strong{syn - flowframe containing non-debris particles}
\item \strong{deb_pos - position of particles that are debris}
\item \strong{syn_pos - position of particles that are not debris}
}
}
\description{
The function takes in a flowframe and identifies debris contained in the
             provided flowframe.
}
\details{
The function uses the \code{\link[flowDensity]{getPeaks}} and
         \code{\link[flowDensity]{deGate}} functions in the flowDensity package to
         identify peaks between peaks and identify cut-off points between these peaks.
         A plot of both channels supplied with horizontal line separating
         debris from other cell populations is also returned.
}
\seealso{
\code{\link{debris_inc}}
}
