% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_cop_corr.R
\name{optCor}
\alias{optCor}
\alias{optCor,cyl_vonmises-method}
\alias{optCor,cyl_quadsec-method}
\alias{optCor,cyl_cubsec-method}
\alias{optCor,cyl_rot_combine-method}
\alias{optCor,cyl_rect_combine-method}
\title{Estimate Copula Parameters from Correlation Measures}
\usage{
optCor(
  copula,
  theta,
  x,
  acc = NULL,
  n = 10000,
  method = c("cor_cyl", "mi_cyl", "tau"),
  ...
)

\S4method{optCor}{cyl_vonmises}(copula, theta, x, acc, n, method = "cor_cyl")

\S4method{optCor}{cyl_quadsec}(copula, theta, x, acc, n, method = "cor_cyl")

\S4method{optCor}{cyl_cubsec}(copula, theta, x, acc, n, method = "cor_cyl", parameter = "both")

\S4method{optCor}{cyl_rot_combine}(copula, theta, x, acc, n, method = "mi_cyl")

\S4method{optCor}{cyl_rect_combine}(copula, theta, x, acc, n, method = "tau", background = FALSE)
}
\arguments{
\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.}

\item{theta}{\link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable).}

\item{x}{\link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable).}

\item{acc}{\link[base]{numeric} value, the interval of the copula parameter
at which to evaluate the correlation.}

\item{n}{\link[base]{numeric} value, the number of sample points at each
optimization step.}

\item{method}{\link[base]{character} string describing what correlation metric
 to use. Either a rank-based circular-linear coefficient (\code{"cor_cyl"}),
mutual information (\code{"mi_cyl"}), or Kendall's tau (\code{"tau"}).}

\item{...}{Additional parameters (see individual methods).}

\item{parameter}{A character string specifying which parameter of a
'\code{\linkS4class{cyl_cubsec}}' copula to optimize,
  \code{"a"}, \code{"b"}, or \code{"both"}}

\item{background}{\link[base]{logical} value describing whether to optimize
the parameter of the background copula, (\code{background = TRUE}) or
the one of the copula in the rectangles(\code{background = FALSE}).}
}
\value{
\link[base]{numeric} \link[base]{vector} containing the estimated
parameter value(s).
}
\description{
See individual methods for more detailed explanations. Kendall's tau is only
available for '\code{\linkS4class{cyl_rect_combine}}' copulas,
for which it is the recommended method to use.
}
\section{Methods (by class)}{
\itemize{
\item \code{cyl_vonmises}: only parameter \code{"kappa"} can be optimized, since parameter
\code{"mu"} does not influence the correlation.

\item \code{cyl_quadsec}: the absolute value of the parameter is optimized, positive
and negative values give the same correlation.

\item \code{cyl_cubsec}: optimization of parameters, \code{"a"} and \code{"b"},
can be done separately or simultaneously.

\item \code{cyl_rot_combine}: the circular-linear correlation coefficient will give a
value close to 0 for any parameter value. It therefore only makes sense to
use \code{method = "mi_cyl"} for the optimization.

\item \code{cyl_rect_combine}: it is recommended to use \code{method = "tau"}, since this
calculates the copula parameter analytically.
}}

\examples{
set.seed(123)

sample <- rcylcop(1000, cyl_rect_combine(copula::frankCopula(2)))
optCor(cyl_rect_combine(copula::frankCopula()),
  theta = sample[,1],
  x = sample[,2],
  method = "tau"
)

optCor(cyl_rect_combine(copula::frankCopula()),
  theta = sample[,1],
  x = sample[,2],
  method = "mi_cyl",
  n = 1000
)

optCor(cyl_rect_combine(copula::claytonCopula()),
  theta = sample[,1],
  x = sample[,2],
  method = "tau"
)

optCor(cyl_quadsec(), theta = sample[,1], x = sample[,2], method = "mi_cyl")
optCor(cyl_quadsec(), theta = sample[,1], x = sample[,2], method = "cor_cyl")
optCor(cyl_quadsec(),
  theta = sample[,1],
  x = sample[,2],
  method = "cor_cyl",
  n = 1000,
  acc = 0.001
)

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{mi_cyl}()}, \code{\link{cor_cyl}()}, \code{\link{optML}()},
\code{\link{opt_auto}()}, \code{copula::\link[copula]{fitCopula}()}.
}
