% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_fan.R, R/stat_fan.R
\name{geom_fan}
\alias{geom_fan}
\alias{stat_fan}
\title{Fan plots for trend and population visualizations}
\usage{
geom_fan(mapping = NULL, data = NULL, position = "identity",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, step = 0.01,
  colorbase = "Oranges", ...)

stat_fan(mapping = NULL, data = NULL, geom = NULL,
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, step = 0.01, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{step}{the number of quantiles to use to compute bins}

\item{colorbase}{the colors to use to draw the ribbon. defaults to RColorBrewer `Oranges`.
See \code{\link[RColorBrewer]{brewer.pal}} for details.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom}{The geometric object to use display the data}
}
\description{
Visualise the distribution of continuous variables by dividing each variables
into a fixed number of bins and returning the bin limits. In fan plots (`geom_fan`)
bins are grouped over all variables and colored after their distance from the center bin,
which corresponds to the median. The center bin corresponds to the strongest shade of `colorbase`,
while other bins get decreasing shades.
}
\details{
`stat_fan` is suitable only for continuous y data. Moreover, if you have less than `1/step` points
you might need to adjust the `step` parameter.
}
\section{Computed variables}{

\describe{
    \item{ymin}{the lower limit of the quantile}
    \item{ymax}{the upper limit of the quantile}
    \item{id}{an identifier for the quantile}
    \item{percent}{the fill colorto use in \code{geom_fan}}
}
}

\examples{
# reformat dataset from short-wide to tall-skinny
EuStockMarkets_ts <- lapply(colnames(EuStockMarkets),function(id) {
  data.frame(id=id,value=as.numeric(EuStockMarkets[,id]))
})
EuStockMarkets_ts <- do.call('rbind',EuStockMarkets_ts)

# plot the distribution of the different stock markets
ggplot(EuStockMarkets_ts,aes(x=id,y=value))+
  geom_fan()

# Change the step
ggplot(EuStockMarkets_ts,aes(x=id,y=value))+
  geom_fan(step=0.05)

# change the default color
ggplot(EuStockMarkets_ts,aes(x=id,y=value))+
  geom_fan(colorbase='Greens')

# any valid RColorBrewer palette will work
ggplot(EuStockMarkets_ts,aes(x=id,y=value))+
  geom_fan(colorbase='RdYlGn')

}
