% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_threshold.R
\name{correlation_threshold}
\alias{correlation_threshold}
\title{Remove redundant variables.}
\usage{
correlation_threshold(variables, sample, cutoff = 0.9, method = "pearson")
}
\arguments{
\item{variables}{character vector specifying observation variables.}

\item{sample}{tbl containing sample used to estimate parameters.}

\item{cutoff}{threshold between [0,1] that defines the minimum correlation of a selected feature.}

\item{method}{optional character string specifying method for calculating correlation. This must be one of the strings \code{"pearson"} (default), \code{"kendall"}, \code{"spearman"}.}
}
\value{
character vector specifying observation variables to be excluded.
}
\description{
\code{correlation_threshold} returns list of variables such that no two variables have a correlation greater than a specified threshold.
}
\details{
\code{correlation_threshold} is a wrapper for \code{caret::findCorrelation}.
}
\examples{

suppressMessages(suppressWarnings(library(magrittr)))
sample <- tibble::data_frame(
   x = rnorm(30),
   y = rnorm(30)/1000
 )
 
sample \%<>\% dplyr::mutate(z = x + rnorm(30) / 10)
variables <- c("x", "y", "z")

head(sample)
cor(sample)

# `x` and `z` are highly correlated; one of them will be removed

correlation_threshold(variables, sample)

}
