% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGAselID.R
\name{AnalyzeResults}
\alias{AnalyzeResults}
\title{AnalyzeResults}
\usage{
AnalyzeResults(individuals, results, randomAssortment = TRUE, chrConf)
}
\arguments{
\item{individuals}{Population of individuals with diploid genotypes.}

\item{results}{Results returned by EvaluationFunction().}

\item{randomAssortment}{Random Assortment of Chromosomes for recombinations. The default value is TRUE.}

\item{chrConf}{Configuration of chromosomes returned by splitChromosomes().}
}
\description{
Ranks individuals according to their fitness and records the results.
}
\examples{
\dontrun{
 library(genefilter)
 library(ALL)
 data(ALL)
 bALL = ALL[, substr(ALL$BT,1,1) == "B"]
 smallALL = bALL[, bALL$mol.biol \%in\% c("BCR/ABL", "NEG")]
 smallALL$mol.biol = factor(smallALL$mol.biol)
 smallALL$BT = factor(smallALL$BT)
 f1 <- pOverA(0.25, log2(100))
 f2 <- function(x) (IQR(x) > 0.5)
 f3 <- ttest(smallALL$mol.biol, p=0.1)
 ff <- filterfun(f1, f2, f3)
 selectedsmallALL <- genefilter(exprs(smallALL), ff)
 smallALL = smallALL[selectedsmallALL, ]
 rm(f1)
 rm(f2)
 rm(f3)
 rm(ff)
 rm(bALL)
 sum(selectedsmallALL)
 set.seed(1357)

 population0<-InitialPopulation(smallALL, 14, 10, FALSE)
 individuals0<-Individuals(population0)
 results0<-EvaluationFunction(smallALL, individuals0, response="mol.biol",
             method=knn.cvI(k=3, l=2), trainTest="LOG")
 chrConf0<-splitChromosomes(smallALL)
 iterRes0<-AnalyzeResults(individuals0, results0, randomAssortment=TRUE, chrConf0)
 }
}

