% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{scale_color_dMod}
\alias{scale_color_dMod}
\title{Standard dMod color palette}
\usage{
scale_color_dMod(...)
}
\arguments{
\item{...}{arguments goint to code{scale_color_manual()}}
}
\description{
Standard dMod color palette
}
\examples{
library(ggplot2)
times <- seq(0, 2*pi, 0.1)
values <- sin(times)
data <- data.frame(
   time = times, 
   value = c(values, 1.2*values, 1.4*values, 1.6*values), 
   group = rep(c("C1", "C2", "C3", "C4"), each = length(times))
)
qplot(time, value, data = data, color = group, geom = "line") + 
   theme_dMod() + scale_color_dMod()
}
