% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backward.R
\name{backward}
\alias{backward}
\title{Infer the backward probabilities for all the nodes of the dagHMM}
\usage{
backward(hmm, observation, bt_seq, kn_states = NULL)
}
\arguments{
\item{hmm}{hmm Object of class List given as output by \code{\link{initHMM}}}

\item{observation}{Dataframe containing the discritized character values of only covariates at each node. Column names of dataframe should be same as the covariate names. Missing values should be denoted by "NA".}

\item{bt_seq}{A vector denoting the order of nodes in which the DAG should be traversed in backward direction(from leaves to roots). Output of \code{\link{bwd_seq_gen}} function.}

\item{kn_states}{(Optional) A (L * 2) dataframe where L is the number of training nodes where state values are known. First column should be the node number and the second column being the corresponding known state values of the nodes}
}
\value{
(2 * N) matrix denoting the backward probabilites at each node of the dag, where "N" is the total number of nodes in the dag
}
\description{
\code{backward} calculates the backward probabilities for all the nodes
}
\details{
The backward probability for state X and observation at node k is defined as the probability of observing the sequence of observations e_k+1, ... ,e_n under the condition that the state at node k is X.
That is:\cr\code{b[X,k] := Prob(E_k+1 = e_k+1, ... , E_n = e_n | X_k = X)}
\cr where \code{E_1...E_n = e_1...e_n} is the sequence of observed emissions and \code{X_k} is a random variable that represents the state at node \code{k}
}
\examples{

library(bnlearn)

tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped dag
states = c("P","N") #"P" represent cases(or positive) and "N" represent controls(or negative)
bnet = model2network("[A][C|A:B][D|A:C][B|A]") #A is the target variable while
                                               #B, C and D are covariates
obsvA=data.frame(list(B=c("L","H","H","L","L"),C=c("H","H","L","L","H"),D=c("L","L","L","H","H")))
hmmA = initHMM(States=states, dagmat= tmat, net=bnet, observation=obsvA)
bt_sq = bwd_seq_gen(hmmA)
kn_st = data.frame(node=c(3),state=c("P"),stringsAsFactors = FALSE)
                   #state at node 3 is known to be "P"
BackwardProbs = backward(hmm=hmmA,observation=obsvA,bt_seq=bt_sq,kn_states=kn_st)
}
\seealso{
\code{\link{forward}}
}
