% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.dalmatian}
\alias{predict.dalmatian}
\title{Prediction method for dalmatian objects}
\usage{
\method{predict}{dalmatian}(
  object,
  newdata = object$df,
  method = "mean",
  population = FALSE,
  se = TRUE,
  ci = TRUE,
  type = c("link", "response"),
  level = c(0.5, 0.95),
  ...
)
}
\arguments{
\item{object}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{newdata}{data frame containing predictor values to predict response variables. Defaults to data in \code{object} if not supplied. (data.frame)}

\item{method}{Method to construct the fitted model. Either posterior mean (\code{"mean"}) or posterior mode (\code{"mode"}) (character)}

\item{population}{If TRUE then generate predictions at the population level rather than the individual level. (logical)}

\item{se}{if TRUE return the posterior standard deviation (logical)}

\item{ci}{returning credible intervals for predictions if TRUE (logical)}

\item{type}{The type of prediction required (as in \code{predict()} for
models generated by \code{glm()}).  The default is on the scale of the
linear predictors; the alternative "response" is on the scale of the
response variable. E.g., if the link between the mean and its linear
predictor is the logit function then the default prediction for the mean
will be on the scale of the log-odds. If the link between the mean and
its linear predictor is the log function then the defaults prediction
will be on the scale of the log.}

\item{level}{vector of levels of credible intervals for predictions (numeric)}

\item{...}{Ignored}
}
\value{
predictions (list)
}
\description{
Prediction method for dalmatian objects
}
