% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dal_fit_curvature_min.R
\name{fit_curvature_min}
\alias{fit_curvature_min}
\title{minimum curvature analysis}
\usage{
fit_curvature_min()
}
\value{
Returns an object of class fit_curvature_max, which inherits from the fit_curvature and dal_transform classes.
The object contains a list with the following elements:
\itemize{
\item x: The position in which the minimum curvature is reached.
\item y: The value where the the minimum curvature occurs.
\item yfit: The value of the minimum curvature.
}
}
\description{
Fitting a curvature model in a sequence of observations. It extracts the the minimum curvature computed.
}
\examples{
x <- seq(from=1,to=10,by=0.5)
dat <- data.frame(x = x, value = log(x), variable = "log")
myfit <- fit_curvature_min()
res <- transform(myfit, dat$value)
head(res)
}
