% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_rf.R
\name{cla_rf}
\alias{cla_rf}
\title{Random Forest for classification}
\usage{
cla_rf(attribute, slevels, nodesize = 5, ntree = 10, mtry = NULL)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{slevels}{possible values for the target classification}

\item{nodesize}{node size}

\item{ntree}{number of trees}

\item{mtry}{number of attributes to build tree}
}
\value{
returns a classification object
}
\description{
Creates a classification object that
uses the Random Forest method
It wraps the randomForest library.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_rf("Species", slevels, ntree=5)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
