% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_radar}
\alias{plot_radar}
\title{Plot radar}
\usage{
plot_radar(data, label_x = "", label_y = "", colors = NULL)
}
\arguments{
\item{data}{data.frame contain x, value, and variable}

\item{label_x}{x-axis label}

\item{label_y}{y-axis label}

\item{colors}{color vector}
}
\value{
returns a ggplot graphic
}
\description{
This function creates a radar chart using ggplot2.
}
\examples{
data <- data.frame(name = "Petal.Length", value = mean(iris$Petal.Length))
data <- rbind(data, data.frame(name = "Petal.Width", value = mean(iris$Petal.Width)))
data <- rbind(data, data.frame(name = "Sepal.Length", value = mean(iris$Sepal.Length)))
data <- rbind(data, data.frame(name = "Sepal.Width", value = mean(iris$Sepal.Width)))

grf <- plot_radar(data, colors="red") + ggplot2::ylim(0, NA)
plot(grf)
}
