% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_smoothing_cluster.R
\name{smoothing_cluster}
\alias{smoothing_cluster}
\title{Smoothing by cluster}
\usage{
smoothing_cluster(n)
}
\arguments{
\item{n}{number of bins}
}
\value{
returns an object of class \code{smoothing_cluster}
}
\description{
Uses clustering method to perform data smoothing.
The input vector is divided into clusters using the k-means algorithm.
The mean of each cluster is then calculated and used as the
smoothed value for all observations within that cluster.
}
\examples{
data(iris)
obj <- smoothing_cluster(n = 2)
obj <- fit(obj, iris$Sepal.Length)
sl.bi <- transform(obj, iris$Sepal.Length)
table(sl.bi)
obj$interval

entro <- evaluate(obj, as.factor(names(sl.bi)), iris$Species)
entro$entropy
}
