% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal_subsampling.R
\name{bal_subsampling}
\alias{bal_subsampling}
\title{Subsampling}
\usage{
bal_subsampling(attribute)
}
\arguments{
\item{attribute}{The class attribute to target balancing using subsampling}
}
\value{
A \code{bal_subsampling} object.
}
\description{
Subsampling balances the class distribution of a dataset by reducing the representation of the majority class in the dataset.
}
\examples{
data(iris)
mod_iris <- iris[c(1:50,51:71,101:111),]

bal <- bal_subsampling('Species')
bal <- daltoolbox::fit(bal, mod_iris)
adjust_iris <- daltoolbox::transform(bal, mod_iris)
table(adjust_iris$Species)
}
