% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evppi.R
\name{calc_evppi}
\alias{calc_evppi}
\title{Estimation of the Expected Value of Partial Perfect Information (EVPPI)
using a linear regression metamodel approach}
\usage{
calc_evppi(
  psa,
  wtp,
  params = NULL,
  outcome = c("nmb", "nhb"),
  type = c("gam", "poly"),
  poly.order = 2,
  k = -1,
  pop = 1,
  progress = TRUE
)
}
\arguments{
\item{psa}{object of class psa, produced by \code{\link{make_psa_obj}}}

\item{wtp}{willingness-to-pay threshold}

\item{params}{A vector of parameter names to be analyzed in terms of EVPPI.}

\item{outcome}{either net monetary benefit (\code{"nmb"})
or net health benefit (\code{"nhb"})}

\item{type}{either generalized additive models (\code{"gam"}) or
polynomial models (\code{"poly"})}

\item{poly.order}{order of the polynomial, if \code{type == "poly"}}

\item{k}{basis dimension, if \code{type == "gam"}}

\item{pop}{scalar that corresponds to the total population}

\item{progress}{\code{TRUE} or \code{FALSE} for whether or not function progress
should be displayed in console.}
}
\value{
A list containing 1) a data.frame with WTP thresholds and corresponding EVPPIs
for the selected parameters and 2) a list of metamodels used to estimate EVPPI for each
strategy at each willingness to pay threshold.
}
\description{
\code{evppi} is used to estimate the Expected Value of Partial Perfect
Information (EVPPI) using a linear regression metamodel approach from a
probabilistic sensitivity analysis (PSA) dataset.
}
\details{
The expected value of partial pefect information (EVPPI) is the expected
value of perfect information from a subset of parameters of interest,
\eqn{\theta_I}, of a cost-effectiveness analysis (CEA) of \eqn{D} different
strategies with parameters \eqn{\theta = \{ \theta_I, \theta_C\}}, where
\eqn{\theta_C} is the set of complimenatry parameters of the CEA. The
function \code{calc_evppi} computes the EVPPI of \eqn{\theta_I} from a
matrix of net monetary benefits \eqn{B} of the CEA. Each column of \eqn{B}
corresponds to the net benefit \eqn{B_d} of strategy \eqn{d}. The function
\code{calc_evppi} computes the EVPPI using a linear regression metamodel
approach following these steps:
\enumerate{
\item Determine the optimal strategy \eqn{d^*} from the expected net
benefits \eqn{\bar{B}}
\deqn{d^* = argmax_{d} \{\bar{B}\}}
\item Compute the opportunity loss for each \eqn{d} strategy, \eqn{L_d}
\deqn{L_d = B_d - B_{d^*}}
\item Estimate a linear metamodel for the opportunity loss of each \eqn{d}
strategy, \eqn{L_d}, by regressing them on the spline basis functions of
\eqn{\theta_I}, \eqn{f(\theta_I)}
\deqn{L_d = \beta_0 + f(\theta_I) + \epsilon,}
where \eqn{\epsilon} is the residual term that captures the complementary
parameters \eqn{\theta_C} and the difference between the original simulation
model and the metamodel.
\item Compute the EVPPI of \eqn{\theta_I} using the estimated losses for
each \eqn{d} strategy, \eqn{\hat{L}_d} from the linear regression metamodel
and applying the following equation:
\deqn{EVPPI_{\theta_I} = \frac{1}{K}\sum_{i=1}^{K}\max_d(\hat{L}_d)}
The spline model in step 3 is fitted using the `mgcv` package.
}
}
\references{
\enumerate{
\item Jalal H, Alarid-Escudero F. A General Gaussian Approximation Approach
for Value of Information Analysis. Med Decis Making. 2018;38(2):174-188.
\item Strong M, Oakley JE, Brennan A. Estimating Multiparameter Partial
Expected Value of Perfect Information from a Probabilistic Sensitivity
Analysis Sample: A Nonparametric Regression Approach. Med Decis Making.
2014;34(3):311–26.
}
}
