## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- eval = FALSE------------------------------------------------------------
#  
#    ...
#    ### ui body
#    dashboardBody(
#  
#      ### changing theme
#      shinyDashboardThemes(
#        theme = "blue_gradient"
#      )
#  
#      ### ui tabs
#      ,tabItems(
#        tabItem(
#          ...
#  

## ---- eval = FALSE------------------------------------------------------------
#  
#    ...
#    ### ui
#    ui <- dashboardPage(
#  
#      ### ui header
#      dashboardHeader(
#  
#        ### changing logo
#        title = shinyDashboardLogo(
#          theme = "blue_gradient",
#          boldText = "Shiny",
#          mainText = "App",
#          badgeText = "v1.1"
#        )
#        ...
#  

## ---- eval = FALSE------------------------------------------------------------
#  
#    ### calling custom theme object in shinydashboard
#      ...
#      ### ui body
#      dashboardBody(
#  
#        ### changing theme
#        customTheme
#  
#        ### ui tabs
#        ,tabItems(
#          tabItem(
#            ...
#  
#    ### creating custom theme object
#    customTheme <- shinyDashboardThemeDIY(
#  
#      ### general
#      appFontFamily = "Arial"
#      ,appFontColor = "rgb(0,0,0)"
#      ,primaryFontColor = "rgb(0,0,0)"
#      ,infoFontColor = "rgb(0,0,0)"
#      ,successFontColor = "rgb(0,0,0)"
#      ,warningFontColor = "rgb(0,0,0)"
#      ,dangerFontColor = "rgb(0,0,0)"
#      ,bodyBackColor = "rgb(248,248,248)"
#  
#      ### header
#      ,logoBackColor = "rgb(23,103,124)"
#  
#      ,headerButtonBackColor = "rgb(238,238,238)"
#      ,headerButtonIconColor = "rgb(75,75,75)"
#      ,headerButtonBackColorHover = "rgb(210,210,210)"
#      ,headerButtonIconColorHover = "rgb(0,0,0)"
#  
#      ,headerBackColor = "rgb(238,238,238)"
#      ,headerBoxShadowColor = "#aaaaaa"
#      ,headerBoxShadowSize = "2px 2px 2px"
#  
#      ### sidebar
#      ,sidebarBackColor = cssGradientThreeColors(
#        direction = "down"
#        ,colorStart = "rgb(20,97,117)"
#        ,colorMiddle = "rgb(56,161,187)"
#        ,colorEnd = "rgb(3,22,56)"
#        ,colorStartPos = 0
#        ,colorMiddlePos = 50
#        ,colorEndPos = 100
#      )
#      ,sidebarPadding = 0
#  
#      ,sidebarMenuBackColor = "transparent"
#      ,sidebarMenuPadding = 0
#      ,sidebarMenuBorderRadius = 0
#  
#      ,sidebarShadowRadius = "3px 5px 5px"
#      ,sidebarShadowColor = "#aaaaaa"
#  
#      ,sidebarUserTextColor = "rgb(255,255,255)"
#  
#      ,sidebarSearchBackColor = "rgb(55,72,80)"
#      ,sidebarSearchIconColor = "rgb(153,153,153)"
#      ,sidebarSearchBorderColor = "rgb(55,72,80)"
#  
#      ,sidebarTabTextColor = "rgb(255,255,255)"
#      ,sidebarTabTextSize = 13
#      ,sidebarTabBorderStyle = "none none solid none"
#      ,sidebarTabBorderColor = "rgb(35,106,135)"
#      ,sidebarTabBorderWidth = 1
#  
#      ,sidebarTabBackColorSelected = cssGradientThreeColors(
#        direction = "right"
#        ,colorStart = "rgba(44,222,235,1)"
#        ,colorMiddle = "rgba(44,222,235,1)"
#        ,colorEnd = "rgba(0,255,213,1)"
#        ,colorStartPos = 0
#        ,colorMiddlePos = 30
#        ,colorEndPos = 100
#      )
#      ,sidebarTabTextColorSelected = "rgb(0,0,0)"
#      ,sidebarTabRadiusSelected = "0px 20px 20px 0px"
#  
#      ,sidebarTabBackColorHover = cssGradientThreeColors(
#        direction = "right"
#        ,colorStart = "rgba(44,222,235,1)"
#        ,colorMiddle = "rgba(44,222,235,1)"
#        ,colorEnd = "rgba(0,255,213,1)"
#        ,colorStartPos = 0
#        ,colorMiddlePos = 30
#        ,colorEndPos = 100
#      )
#      ,sidebarTabTextColorHover = "rgb(50,50,50)"
#      ,sidebarTabBorderStyleHover = "none none solid none"
#      ,sidebarTabBorderColorHover = "rgb(75,126,151)"
#      ,sidebarTabBorderWidthHover = 1
#      ,sidebarTabRadiusHover = "0px 20px 20px 0px"
#  
#      ### boxes
#      ,boxBackColor = "rgb(255,255,255)"
#      ,boxBorderRadius = 5
#      ,boxShadowSize = "0px 1px 1px"
#      ,boxShadowColor = "rgba(0,0,0,.1)"
#      ,boxTitleSize = 16
#      ,boxDefaultColor = "rgb(210,214,220)"
#      ,boxPrimaryColor = "rgba(44,222,235,1)"
#      ,boxInfoColor = "rgb(210,214,220)"
#      ,boxSuccessColor = "rgba(0,255,213,1)"
#      ,boxWarningColor = "rgb(244,156,104)"
#      ,boxDangerColor = "rgb(255,88,55)"
#  
#      ,tabBoxTabColor = "rgb(255,255,255)"
#      ,tabBoxTabTextSize = 14
#      ,tabBoxTabTextColor = "rgb(0,0,0)"
#      ,tabBoxTabTextColorSelected = "rgb(0,0,0)"
#      ,tabBoxBackColor = "rgb(255,255,255)"
#      ,tabBoxHighlightColor = "rgba(44,222,235,1)"
#      ,tabBoxBorderRadius = 5
#  
#      ### inputs
#      ,buttonBackColor = "rgb(245,245,245)"
#      ,buttonTextColor = "rgb(0,0,0)"
#      ,buttonBorderColor = "rgb(200,200,200)"
#      ,buttonBorderRadius = 5
#  
#      ,buttonBackColorHover = "rgb(235,235,235)"
#      ,buttonTextColorHover = "rgb(100,100,100)"
#      ,buttonBorderColorHover = "rgb(200,200,200)"
#  
#      ,textboxBackColor = "rgb(255,255,255)"
#      ,textboxBorderColor = "rgb(200,200,200)"
#      ,textboxBorderRadius = 5
#      ,textboxBackColorSelect = "rgb(245,245,245)"
#      ,textboxBorderColorSelect = "rgb(200,200,200)"
#  
#      ### tables
#      ,tableBackColor = "rgb(255,255,255)"
#      ,tableBorderColor = "rgb(240,240,240)"
#      ,tableBorderTopSize = 1
#      ,tableBorderRowSize = 1
#  
#    )
#  
#  

## ---- eval = FALSE------------------------------------------------------------
#  
#    ### calling custom logo object in shinydashboard
#      ...
#      ### ui
#      ui <- dashboardPage(
#  
#        ### ui header
#        dashboardHeader(
#  
#          ### changing logo
#          title = customLogo
#          ...
#  
#    ### creating custom logo object
#    customLogo <- shinyDashboardLogoDIY(
#  
#      boldText = "SD"
#      ,mainText = "Themes"
#      ,textSize = 16
#      ,badgeText = "v1.1"
#      ,badgeTextColor = "white"
#      ,badgeTextSize = 2
#      ,badgeBackColor = "#40E0D0"
#      ,badgeBorderRadius = 3
#  
#    )
#  

