#ifndef dt_FREAD_LOOKUPS_H
#define dt_FREAD_LOOKUPS_H

// characters re-interpreted as hex digits (or 99 for characters that are not
// valid digits). Thus, this table maps
//   '0' .. '9'  into  0 .. 9
//   'a' .. 'f'  into  10 .. 15
//   'A' .. 'F'  into  10 .. 15
//   everything else into 99
const uint8_t hexdigits[256] = {
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x00 - 0x0F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x10 - 0x1F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x20 - 0x2F
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  99, 99, 99, 99, 99, 99,  // 0x30 - 0x3F
  99, 10, 11, 12, 13, 14, 15, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x40 - 0x4F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x50 - 0x5F
  99, 10, 11, 12, 13, 14, 15, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x60 - 0x6F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x70 - 0x7F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x80 - 0x8F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x90 - 0x9F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xA0 - 0xAF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xB0 - 0xBF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xC0 - 0xCF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xD0 - 0xDF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xE0 - 0xEF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99   // 0xF0 - 0xFF
};


const long double pow10lookup[701] = {
1.0E-350L,
1.0E-349L,
1.0E-348L,
1.0E-347L,
1.0E-346L,
1.0E-345L,
1.0E-344L,
1.0E-343L,
1.0E-342L,
1.0E-341L,
1.0E-340L,
1.0E-339L,
1.0E-338L,
1.0E-337L,
1.0E-336L,
1.0E-335L,
1.0E-334L,
1.0E-333L,
1.0E-332L,
1.0E-331L,
1.0E-330L,
1.0E-329L,
1.0E-328L,
1.0E-327L,
1.0E-326L,
1.0E-325L,
1.0E-324L,
1.0E-323L,
1.0E-322L,
1.0E-321L,
1.0E-320L,
1.0E-319L,
1.0E-318L,
1.0E-317L,
1.0E-316L,
1.0E-315L,
1.0E-314L,
1.0E-313L,
1.0E-312L,
1.0E-311L,
1.0E-310L,
1.0E-309L,
1.0E-308L,
1.0E-307L,
1.0E-306L,
1.0E-305L,
1.0E-304L,
1.0E-303L,
1.0E-302L,
1.0E-301L,
1.0E-300L,
1.0E-299L,
1.0E-298L,
1.0E-297L,
1.0E-296L,
1.0E-295L,
1.0E-294L,
1.0E-293L,
1.0E-292L,
1.0E-291L,
1.0E-290L,
1.0E-289L,
1.0E-288L,
1.0E-287L,
1.0E-286L,
1.0E-285L,
1.0E-284L,
1.0E-283L,
1.0E-282L,
1.0E-281L,
1.0E-280L,
1.0E-279L,
1.0E-278L,
1.0E-277L,
1.0E-276L,
1.0E-275L,
1.0E-274L,
1.0E-273L,
1.0E-272L,
1.0E-271L,
1.0E-270L,
1.0E-269L,
1.0E-268L,
1.0E-267L,
1.0E-266L,
1.0E-265L,
1.0E-264L,
1.0E-263L,
1.0E-262L,
1.0E-261L,
1.0E-260L,
1.0E-259L,
1.0E-258L,
1.0E-257L,
1.0E-256L,
1.0E-255L,
1.0E-254L,
1.0E-253L,
1.0E-252L,
1.0E-251L,
1.0E-250L,
1.0E-249L,
1.0E-248L,
1.0E-247L,
1.0E-246L,
1.0E-245L,
1.0E-244L,
1.0E-243L,
1.0E-242L,
1.0E-241L,
1.0E-240L,
1.0E-239L,
1.0E-238L,
1.0E-237L,
1.0E-236L,
1.0E-235L,
1.0E-234L,
1.0E-233L,
1.0E-232L,
1.0E-231L,
1.0E-230L,
1.0E-229L,
1.0E-228L,
1.0E-227L,
1.0E-226L,
1.0E-225L,
1.0E-224L,
1.0E-223L,
1.0E-222L,
1.0E-221L,
1.0E-220L,
1.0E-219L,
1.0E-218L,
1.0E-217L,
1.0E-216L,
1.0E-215L,
1.0E-214L,
1.0E-213L,
1.0E-212L,
1.0E-211L,
1.0E-210L,
1.0E-209L,
1.0E-208L,
1.0E-207L,
1.0E-206L,
1.0E-205L,
1.0E-204L,
1.0E-203L,
1.0E-202L,
1.0E-201L,
1.0E-200L,
1.0E-199L,
1.0E-198L,
1.0E-197L,
1.0E-196L,
1.0E-195L,
1.0E-194L,
1.0E-193L,
1.0E-192L,
1.0E-191L,
1.0E-190L,
1.0E-189L,
1.0E-188L,
1.0E-187L,
1.0E-186L,
1.0E-185L,
1.0E-184L,
1.0E-183L,
1.0E-182L,
1.0E-181L,
1.0E-180L,
1.0E-179L,
1.0E-178L,
1.0E-177L,
1.0E-176L,
1.0E-175L,
1.0E-174L,
1.0E-173L,
1.0E-172L,
1.0E-171L,
1.0E-170L,
1.0E-169L,
1.0E-168L,
1.0E-167L,
1.0E-166L,
1.0E-165L,
1.0E-164L,
1.0E-163L,
1.0E-162L,
1.0E-161L,
1.0E-160L,
1.0E-159L,
1.0E-158L,
1.0E-157L,
1.0E-156L,
1.0E-155L,
1.0E-154L,
1.0E-153L,
1.0E-152L,
1.0E-151L,
1.0E-150L,
1.0E-149L,
1.0E-148L,
1.0E-147L,
1.0E-146L,
1.0E-145L,
1.0E-144L,
1.0E-143L,
1.0E-142L,
1.0E-141L,
1.0E-140L,
1.0E-139L,
1.0E-138L,
1.0E-137L,
1.0E-136L,
1.0E-135L,
1.0E-134L,
1.0E-133L,
1.0E-132L,
1.0E-131L,
1.0E-130L,
1.0E-129L,
1.0E-128L,
1.0E-127L,
1.0E-126L,
1.0E-125L,
1.0E-124L,
1.0E-123L,
1.0E-122L,
1.0E-121L,
1.0E-120L,
1.0E-119L,
1.0E-118L,
1.0E-117L,
1.0E-116L,
1.0E-115L,
1.0E-114L,
1.0E-113L,
1.0E-112L,
1.0E-111L,
1.0E-110L,
1.0E-109L,
1.0E-108L,
1.0E-107L,
1.0E-106L,
1.0E-105L,
1.0E-104L,
1.0E-103L,
1.0E-102L,
1.0E-101L,
1.0E-100L,
1.0E-99L,
1.0E-98L,
1.0E-97L,
1.0E-96L,
1.0E-95L,
1.0E-94L,
1.0E-93L,
1.0E-92L,
1.0E-91L,
1.0E-90L,
1.0E-89L,
1.0E-88L,
1.0E-87L,
1.0E-86L,
1.0E-85L,
1.0E-84L,
1.0E-83L,
1.0E-82L,
1.0E-81L,
1.0E-80L,
1.0E-79L,
1.0E-78L,
1.0E-77L,
1.0E-76L,
1.0E-75L,
1.0E-74L,
1.0E-73L,
1.0E-72L,
1.0E-71L,
1.0E-70L,
1.0E-69L,
1.0E-68L,
1.0E-67L,
1.0E-66L,
1.0E-65L,
1.0E-64L,
1.0E-63L,
1.0E-62L,
1.0E-61L,
1.0E-60L,
1.0E-59L,
1.0E-58L,
1.0E-57L,
1.0E-56L,
1.0E-55L,
1.0E-54L,
1.0E-53L,
1.0E-52L,
1.0E-51L,
1.0E-50L,
1.0E-49L,
1.0E-48L,
1.0E-47L,
1.0E-46L,
1.0E-45L,
1.0E-44L,
1.0E-43L,
1.0E-42L,
1.0E-41L,
1.0E-40L,
1.0E-39L,
1.0E-38L,
1.0E-37L,
1.0E-36L,
1.0E-35L,
1.0E-34L,
1.0E-33L,
1.0E-32L,
1.0E-31L,
1.0E-30L,
1.0E-29L,
1.0E-28L,
1.0E-27L,
1.0E-26L,
1.0E-25L,
1.0E-24L,
1.0E-23L,
1.0E-22L,
1.0E-21L,
1.0E-20L,
1.0E-19L,
1.0E-18L,
1.0E-17L,
1.0E-16L,
1.0E-15L,
1.0E-14L,
1.0E-13L,
1.0E-12L,
1.0E-11L,
1.0E-10L,
1.0E-9L,
1.0E-8L,
1.0E-7L,
1.0E-6L,
1.0E-5L,
1.0E-4L,
1.0E-3L,
1.0E-2L,
1.0E-1L,
1.0E0L,
1.0E1L,
1.0E2L,
1.0E3L,
1.0E4L,
1.0E5L,
1.0E6L,
1.0E7L,
1.0E8L,
1.0E9L,
1.0E10L,
1.0E11L,
1.0E12L,
1.0E13L,
1.0E14L,
1.0E15L,
1.0E16L,
1.0E17L,
1.0E18L,
1.0E19L,
1.0E20L,
1.0E21L,
1.0E22L,
1.0E23L,
1.0E24L,
1.0E25L,
1.0E26L,
1.0E27L,
1.0E28L,
1.0E29L,
1.0E30L,
1.0E31L,
1.0E32L,
1.0E33L,
1.0E34L,
1.0E35L,
1.0E36L,
1.0E37L,
1.0E38L,
1.0E39L,
1.0E40L,
1.0E41L,
1.0E42L,
1.0E43L,
1.0E44L,
1.0E45L,
1.0E46L,
1.0E47L,
1.0E48L,
1.0E49L,
1.0E50L,
1.0E51L,
1.0E52L,
1.0E53L,
1.0E54L,
1.0E55L,
1.0E56L,
1.0E57L,
1.0E58L,
1.0E59L,
1.0E60L,
1.0E61L,
1.0E62L,
1.0E63L,
1.0E64L,
1.0E65L,
1.0E66L,
1.0E67L,
1.0E68L,
1.0E69L,
1.0E70L,
1.0E71L,
1.0E72L,
1.0E73L,
1.0E74L,
1.0E75L,
1.0E76L,
1.0E77L,
1.0E78L,
1.0E79L,
1.0E80L,
1.0E81L,
1.0E82L,
1.0E83L,
1.0E84L,
1.0E85L,
1.0E86L,
1.0E87L,
1.0E88L,
1.0E89L,
1.0E90L,
1.0E91L,
1.0E92L,
1.0E93L,
1.0E94L,
1.0E95L,
1.0E96L,
1.0E97L,
1.0E98L,
1.0E99L,
1.0E100L,
1.0E101L,
1.0E102L,
1.0E103L,
1.0E104L,
1.0E105L,
1.0E106L,
1.0E107L,
1.0E108L,
1.0E109L,
1.0E110L,
1.0E111L,
1.0E112L,
1.0E113L,
1.0E114L,
1.0E115L,
1.0E116L,
1.0E117L,
1.0E118L,
1.0E119L,
1.0E120L,
1.0E121L,
1.0E122L,
1.0E123L,
1.0E124L,
1.0E125L,
1.0E126L,
1.0E127L,
1.0E128L,
1.0E129L,
1.0E130L,
1.0E131L,
1.0E132L,
1.0E133L,
1.0E134L,
1.0E135L,
1.0E136L,
1.0E137L,
1.0E138L,
1.0E139L,
1.0E140L,
1.0E141L,
1.0E142L,
1.0E143L,
1.0E144L,
1.0E145L,
1.0E146L,
1.0E147L,
1.0E148L,
1.0E149L,
1.0E150L,
1.0E151L,
1.0E152L,
1.0E153L,
1.0E154L,
1.0E155L,
1.0E156L,
1.0E157L,
1.0E158L,
1.0E159L,
1.0E160L,
1.0E161L,
1.0E162L,
1.0E163L,
1.0E164L,
1.0E165L,
1.0E166L,
1.0E167L,
1.0E168L,
1.0E169L,
1.0E170L,
1.0E171L,
1.0E172L,
1.0E173L,
1.0E174L,
1.0E175L,
1.0E176L,
1.0E177L,
1.0E178L,
1.0E179L,
1.0E180L,
1.0E181L,
1.0E182L,
1.0E183L,
1.0E184L,
1.0E185L,
1.0E186L,
1.0E187L,
1.0E188L,
1.0E189L,
1.0E190L,
1.0E191L,
1.0E192L,
1.0E193L,
1.0E194L,
1.0E195L,
1.0E196L,
1.0E197L,
1.0E198L,
1.0E199L,
1.0E200L,
1.0E201L,
1.0E202L,
1.0E203L,
1.0E204L,
1.0E205L,
1.0E206L,
1.0E207L,
1.0E208L,
1.0E209L,
1.0E210L,
1.0E211L,
1.0E212L,
1.0E213L,
1.0E214L,
1.0E215L,
1.0E216L,
1.0E217L,
1.0E218L,
1.0E219L,
1.0E220L,
1.0E221L,
1.0E222L,
1.0E223L,
1.0E224L,
1.0E225L,
1.0E226L,
1.0E227L,
1.0E228L,
1.0E229L,
1.0E230L,
1.0E231L,
1.0E232L,
1.0E233L,
1.0E234L,
1.0E235L,
1.0E236L,
1.0E237L,
1.0E238L,
1.0E239L,
1.0E240L,
1.0E241L,
1.0E242L,
1.0E243L,
1.0E244L,
1.0E245L,
1.0E246L,
1.0E247L,
1.0E248L,
1.0E249L,
1.0E250L,
1.0E251L,
1.0E252L,
1.0E253L,
1.0E254L,
1.0E255L,
1.0E256L,
1.0E257L,
1.0E258L,
1.0E259L,
1.0E260L,
1.0E261L,
1.0E262L,
1.0E263L,
1.0E264L,
1.0E265L,
1.0E266L,
1.0E267L,
1.0E268L,
1.0E269L,
1.0E270L,
1.0E271L,
1.0E272L,
1.0E273L,
1.0E274L,
1.0E275L,
1.0E276L,
1.0E277L,
1.0E278L,
1.0E279L,
1.0E280L,
1.0E281L,
1.0E282L,
1.0E283L,
1.0E284L,
1.0E285L,
1.0E286L,
1.0E287L,
1.0E288L,
1.0E289L,
1.0E290L,
1.0E291L,
1.0E292L,
1.0E293L,
1.0E294L,
1.0E295L,
1.0E296L,
1.0E297L,
1.0E298L,
1.0E299L,
1.0E300L,
1.0E301L,
1.0E302L,
1.0E303L,
1.0E304L,
1.0E305L,
1.0E306L,
1.0E307L,
1.0E308L,
1.0E309L,
1.0E310L,
1.0E311L,
1.0E312L,
1.0E313L,
1.0E314L,
1.0E315L,
1.0E316L,
1.0E317L,
1.0E318L,
1.0E319L,
1.0E320L,
1.0E321L,
1.0E322L,
1.0E323L,
1.0E324L,
1.0E325L,
1.0E326L,
1.0E327L,
1.0E328L,
1.0E329L,
1.0E330L,
1.0E331L,
1.0E332L,
1.0E333L,
1.0E334L,
1.0E335L,
1.0E336L,
1.0E337L,
1.0E338L,
1.0E339L,
1.0E340L,
1.0E341L,
1.0E342L,
1.0E343L,
1.0E344L,
1.0E345L,
1.0E346L,
1.0E347L,
1.0E348L,
1.0E349L,
1.0E350L
};

#endif
