% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods_sideeffect.R
\name{Sort}
\alias{Sort}
\title{Sort children of a \code{Node} or an entire \code{data.tree} structure}
\usage{
# node$Sort(attribute, ..., decreasing = FALSE, recursive = TRUE) 
Sort(node, attribute, ..., decreasing = FALSE, recursive = TRUE)
}
\arguments{
\item{node}{The node whose children are to be sorted}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} or a \bold{property/active} of each \code{Node} in the tree, e.g. \code{acme$Get("p")} or \code{acme$Get("position")}
  \item b.) the name of a \bold{method} of each \code{Node} in the tree, e.g. \code{acme$Get("levelZeroBased")}, where e.g. \code{acme$levelZeroBased <- function() acme$level - 1}
  \item c.) a \bold{function}, whose first argument must be a \code{Node} e.g. \code{acme$Get(function(node) node$cost * node$p)}
 }}

\item{...}{any parameters to be passed on the the attribute (in case it's a method or a 
function)}

\item{decreasing}{sort order}

\item{recursive}{if \code{TRUE}, Sort will be called recursively on the \code{Node}'s children. 
This allows sorting an entire tree.}
}
\value{
Returns the node on which Sort is called, invisibly. This can be useful to chain Node methods.
}
\description{
You can sort with respect to any argument of the tree. But note that sorting has
side-effects, meaning that you modify the underlying, original data.tree object structure.
}
\examples{
data(acme)
acme$Do(function(x) x$totalCost <- Aggregate(x, "cost", sum), traversal = "post-order")
acme$Sort("totalCost", decreasing = FALSE)
print(acme, "totalCost")

}
\seealso{
\code{\link{Node}}

\code{\link{Revert}}
}
\keyword{internal}

